/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Metadata {
    private final String eventType;
    private final String eid;
    private final OffsetDateTime occurredAt;
    private final OffsetDateTime receivedAt;
    private final String flowId;
    private final Map<String, String> spanCtx;

    @JsonCreator
    @Deprecated
    private Metadata(@JsonProperty(value="event_type") String eventType, @JsonProperty(value="eid") String eid, @JsonProperty(value="occurred_at") String occurredAt, @JsonProperty(value="received_at") String receivedAt, @JsonProperty(value="flow_id") String flowId, @JsonProperty(value="span_ctx") Map<String, String> spanCtx) {
        this(eventType, eid, occurredAt == null ? null : OffsetDateTime.parse(occurredAt), receivedAt == null ? null : OffsetDateTime.parse(receivedAt), flowId, spanCtx);
    }

    public Metadata(String eventType, String eid, OffsetDateTime occurredAt, OffsetDateTime receivedAt, String flowId) {
        this(eventType, eid, occurredAt, receivedAt, flowId, null);
    }

    public Metadata(String eventType, String eid, OffsetDateTime occurredAt, OffsetDateTime receivedAt, String flowId, Map<String, String> spanCtx) {
        this.eventType = eventType;
        this.eid = eid;
        this.occurredAt = occurredAt;
        this.receivedAt = receivedAt;
        this.flowId = flowId;
        this.spanCtx = spanCtx == null ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, String>(spanCtx));
    }

    public Metadata(String eid, OffsetDateTime occurredAt) {
        this(null, eid, occurredAt, null, null, null);
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEid() {
        return this.eid;
    }

    public OffsetDateTime getOccurredAt() {
        return this.occurredAt;
    }

    public OffsetDateTime getReceivedAt() {
        return this.receivedAt;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public Map<String, String> getSpanCtx() {
        return this.spanCtx;
    }
}

