/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.domain.Cursor;
import org.zalando.fahrschein.domain.Subscription;

public class ManagedCursorManager
implements CursorManager {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedCursorManager.class);
    private static final TypeReference<List<Cursor>> LIST_OF_CURSORS = new TypeReference<List<Cursor>>(){};
    private final URI baseUri;
    private final ClientHttpRequestFactory clientHttpRequestFactory;
    private final ObjectMapper objectMapper;
    private final Map<String, Subscription> subscriptions;

    public ManagedCursorManager(URI baseUri, ClientHttpRequestFactory clientHttpRequestFactory, ObjectMapper objectMapper) {
        this.baseUri = baseUri;
        this.clientHttpRequestFactory = clientHttpRequestFactory;
        this.objectMapper = objectMapper;
        this.subscriptions = new HashMap<String, Subscription>();
    }

    @Override
    public void addSubscription(Subscription subscription) {
        String eventName = (String)Iterables.getOnlyElement(subscription.getEventTypes());
        this.subscriptions.put(eventName, subscription);
    }

    @Override
    public void onSuccess(String eventName, Cursor cursor) throws IOException {
        Subscription subscription = this.subscriptions.get(eventName);
        URI subscriptionUrl = this.baseUri.resolve(String.format("/subscriptions/%s/cursors", subscription.getId()));
        ClientHttpRequest request = this.clientHttpRequestFactory.createRequest(subscriptionUrl, HttpMethod.PUT);
        request.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        try (OutputStream os = request.getBody();){
            this.objectMapper.writeValue(os, Collections.singleton(cursor));
        }
        var7_7 = null;
        try (ClientHttpResponse response = request.execute();){
            if (response.getStatusCode().value() == HttpStatus.NO_CONTENT.value()) {
                LOG.warn("Cursor for event [{}] in partition [{}] with offset [{}] was already committed", new Object[]{eventName, cursor.getPartition(), cursor.getOffset()});
            } else if (response.getStatusCode().is2xxSuccessful()) {
                LOG.debug("Successfully committed cursor for event [{}] in partition [{}] with offset [{}]", new Object[]{eventName, cursor.getPartition(), cursor.getOffset()});
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
    }

    @Override
    public void onError(String eventName, Cursor cursor, Throwable throwable) {
    }

    /*
     * Exception decompiling
     */
    @Override
    public Collection<Cursor> getCursors(String eventName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

