/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.io.IOException;
import java.util.Collection;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.domain.Cursor;

public class PersistentCursorManager
implements CursorManager {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentCursorManager.class);
    private final JdbcTemplate template;
    private final String consumerName;

    public PersistentCursorManager(JdbcTemplate template, String consumerName) {
        this.template = template;
        this.consumerName = consumerName;
    }

    public PersistentCursorManager(DataSource dataSource, String consumerName) {
        this(new JdbcTemplate(dataSource), consumerName);
    }

    @Override
    public void onSuccess(String eventName, Cursor cursor) throws IOException {
        this.template.queryForObject("SELECT * FROM nakadi_cursor_update(?, ?, ?, ?)", new Object[]{this.consumerName, eventName, cursor.getPartition(), cursor.getOffset()}, Integer.class);
    }

    @Override
    public void onError(String eventName, Cursor cursor, Throwable throwable) {
        LOG.warn("Exception while processing events for [{}] on partition [{}] at offset [{}]", new Object[]{eventName, cursor.getPartition(), cursor.getOffset(), throwable});
    }

    @Override
    public Collection<Cursor> getCursors(String eventName) throws IOException {
        return this.template.query("SELECT * FROM nakadi_cursor_find_by_event_name(?, ?)", new Object[]{this.consumerName, eventName}, (resultSet, i) -> new Cursor(resultSet.getString(2), resultSet.getString(3)));
    }
}

