/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.DefaultObjectMapper;
import org.zalando.fahrschein.EventPublishingException;
import org.zalando.fahrschein.ManagedCursorManager;
import org.zalando.fahrschein.NakadiClientBuilder;
import org.zalando.fahrschein.Preconditions;
import org.zalando.fahrschein.StreamBuilder;
import org.zalando.fahrschein.StreamBuilders;
import org.zalando.fahrschein.SubscriptionBuilder;
import org.zalando.fahrschein.domain.Authorization;
import org.zalando.fahrschein.domain.Cursor;
import org.zalando.fahrschein.domain.Partition;
import org.zalando.fahrschein.domain.Subscription;
import org.zalando.fahrschein.domain.SubscriptionRequest;
import org.zalando.fahrschein.http.api.ContentType;
import org.zalando.fahrschein.http.api.Request;
import org.zalando.fahrschein.http.api.RequestFactory;
import org.zalando.fahrschein.http.api.Response;

public class NakadiClient {
    private static final Logger LOG = LoggerFactory.getLogger(NakadiClient.class);
    private static final TypeReference<List<Partition>> LIST_OF_PARTITIONS = new TypeReference<List<Partition>>(){};
    private final URI baseUri;
    private final RequestFactory clientHttpRequestFactory;
    private final ObjectMapper internalObjectMapper;
    private final ObjectMapper objectMapper;
    private final CursorManager cursorManager;

    public static NakadiClientBuilder builder(URI baseUri, RequestFactory clientHttpRequestFactory) {
        return new NakadiClientBuilder(baseUri, clientHttpRequestFactory);
    }

    NakadiClient(URI baseUri, RequestFactory clientHttpRequestFactory, ObjectMapper objectMapper, CursorManager cursorManager) {
        this.baseUri = baseUri;
        this.clientHttpRequestFactory = clientHttpRequestFactory;
        this.objectMapper = objectMapper;
        this.internalObjectMapper = DefaultObjectMapper.INSTANCE;
        this.cursorManager = cursorManager;
    }

    public List<Partition> getPartitions(String eventName) throws IOException {
        URI uri = this.baseUri.resolve(String.format("/event-types/%s/partitions", eventName));
        Request request = this.clientHttpRequestFactory.createRequest(uri, "GET");
        try (Response response = request.execute();){
            List list;
            block12: {
                InputStream is = response.getBody();
                try {
                    list = (List)this.internalObjectMapper.readValue(is, LIST_OF_PARTITIONS);
                    if (is == null) break block12;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return list;
        }
    }

    public <T> void publish(String eventName, List<T> events) throws EventPublishingException, IOException {
        URI uri = this.baseUri.resolve(String.format("/event-types/%s/events", eventName));
        Request request = this.clientHttpRequestFactory.createRequest(uri, "POST");
        request.getHeaders().setContentType(ContentType.APPLICATION_JSON);
        try (OutputStream body = request.getBody();){
            this.objectMapper.writeValue(body, events);
        }
        try (Response response = request.execute();){
            LOG.debug("Successfully published [{}] events for [{}]", (Object)events.size(), (Object)eventName);
        }
    }

    @Deprecated
    public Subscription subscribe(String applicationName, String eventName, String consumerGroup) throws IOException {
        return this.subscription(applicationName, eventName).withConsumerGroup(consumerGroup).subscribe();
    }

    public SubscriptionBuilder subscription(String applicationName, String eventName) throws IOException {
        return new SubscriptionBuilder(this, applicationName, Collections.singleton(eventName));
    }

    public SubscriptionBuilder subscription(String applicationName, Set<String> eventNames) throws IOException {
        return new SubscriptionBuilder(this, applicationName, eventNames);
    }

    public void deleteSubscription(String subscriptionId) throws IOException {
        Preconditions.checkArgument(!subscriptionId.isEmpty(), "Subscription ID cannot be empty.");
        URI uri = this.baseUri.resolve(String.format("/subscriptions/%s", subscriptionId));
        Request request = this.clientHttpRequestFactory.createRequest(uri, "DELETE");
        request.getHeaders().setContentType(ContentType.APPLICATION_JSON);
        try (Response response = request.execute();){
            int status = response.getStatusCode();
            if (status == 204) {
                LOG.debug("Successfully deleted subscription [{}]", (Object)subscriptionId);
            }
        }
    }

    Subscription subscribe(String applicationName, Set<String> eventNames, String consumerGroup, SubscriptionRequest.Position readFrom, @Nullable List<Cursor> initialCursors, @Nullable Authorization authorization) throws IOException {
        Preconditions.checkArgument(readFrom != SubscriptionRequest.Position.CURSORS || initialCursors != null && !initialCursors.isEmpty(), "Initial cursors are required for position: cursors");
        SubscriptionRequest subscription = new SubscriptionRequest(applicationName, eventNames, consumerGroup, readFrom, initialCursors, authorization);
        URI uri = this.baseUri.resolve("/subscriptions");
        Request request = this.clientHttpRequestFactory.createRequest(uri, "POST");
        request.getHeaders().setContentType(ContentType.APPLICATION_JSON);
        try (OutputStream os = request.getBody();){
            this.internalObjectMapper.writeValue(os, (Object)subscription);
        }
        try (Response response = request.execute();){
            Subscription subscription2;
            block19: {
                InputStream is = response.getBody();
                try {
                    Subscription subscriptionResponse = (Subscription)this.internalObjectMapper.readValue(is, Subscription.class);
                    LOG.info("Created subscription for event {} with id [{}]", subscription.getEventTypes(), (Object)subscriptionResponse.getId());
                    this.cursorManager.addSubscription(subscriptionResponse);
                    subscription2 = subscriptionResponse;
                    if (is == null) break block19;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return subscription2;
        }
    }

    public StreamBuilder.SubscriptionStreamBuilder stream(Subscription subscription) {
        Preconditions.checkState(this.cursorManager instanceof ManagedCursorManager, "Subscription api requires a ManagedCursorManager");
        return new StreamBuilders.SubscriptionStreamBuilderImpl(this.baseUri, this.clientHttpRequestFactory, this.cursorManager, this.objectMapper, subscription);
    }

    public StreamBuilder.LowLevelStreamBuilder stream(String eventName) {
        return new StreamBuilders.LowLevelStreamBuilderImpl(this.baseUri, this.clientHttpRequestFactory, this.cursorManager, this.objectMapper, eventName);
    }
}

