/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.ExponentialBackoffStrategy;

public class EqualJitterBackoffStrategy
extends ExponentialBackoffStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(EqualJitterBackoffStrategy.class);
    private final Random random = new Random();

    public EqualJitterBackoffStrategy() {
    }

    public EqualJitterBackoffStrategy(int initialDelay, double backoffFactor, long maxDelay, int maxRetries) {
        super(initialDelay, backoffFactor, maxDelay, maxRetries);
    }

    private EqualJitterBackoffStrategy(ExponentialBackoffStrategy other) {
        super(other);
    }

    @Override
    public EqualJitterBackoffStrategy withMaxRetries(int maxRetries) {
        return new EqualJitterBackoffStrategy(super.withMaxRetries(maxRetries));
    }

    @Override
    protected long calculateDelay(double count) {
        long ceil = super.calculateDelay(count);
        return ceil / 2L + (long)(this.random.nextDouble() * (double)ceil / 2.0);
    }
}

