/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.io.IOException;
import java.util.Formatter;
import java.util.Locale;
import org.zalando.fahrschein.domain.BatchItemResponse;

public class EventPublishingException
extends IOException {
    private final BatchItemResponse[] responses;

    public EventPublishingException(BatchItemResponse[] responses) {
        super(EventPublishingException.formatMessage(responses));
        this.responses = responses;
    }

    private static String formatMessage(BatchItemResponse[] responses) {
        Formatter fmt = new Formatter(Locale.ROOT);
        for (int i = 0; i < responses.length; ++i) {
            BatchItemResponse res = responses[i];
            fmt.format("Event publishing of [%s] returned status [%s] in step [%s] with detail [%s]%s", new Object[]{res.getEid(), res.getPublishingStatus(), res.getStep(), res.getDetail(), i < responses.length - 1 ? ", " : ""});
        }
        return fmt.toString();
    }

    public BatchItemResponse[] getResponses() {
        return this.responses;
    }
}

