/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.BackoffException;
import org.zalando.fahrschein.BackoffStrategy;
import org.zalando.fahrschein.IOCallable;
import org.zalando.fahrschein.Preconditions;

public class ExponentialBackoffStrategy
implements BackoffStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ExponentialBackoffStrategy.class);
    public static final int DEFAULT_INITIAL_DELAY = 500;
    public static final double DEFAULT_BACKOFF_FACTOR = 1.5;
    public static final long DEFAULT_MAX_DELAY = 600000L;
    private final int initialDelay;
    private final double backoffFactor;
    private final long maxDelay;
    private final int maxRetries;

    public ExponentialBackoffStrategy() {
        this(500, 1.5, 600000L, -1);
    }

    public ExponentialBackoffStrategy(int initialDelay, double backoffFactor, long maxDelay, int maxRetries) {
        Preconditions.checkState(initialDelay > 0, "Initial delay should be bigger than 0");
        this.initialDelay = initialDelay;
        this.backoffFactor = backoffFactor;
        this.maxDelay = maxDelay;
        this.maxRetries = maxRetries;
    }

    protected ExponentialBackoffStrategy(ExponentialBackoffStrategy other) {
        this(other.initialDelay, other.backoffFactor, other.maxDelay, other.maxRetries);
    }

    public ExponentialBackoffStrategy withMaxRetries(int maxRetries) {
        return new ExponentialBackoffStrategy(this.initialDelay, this.backoffFactor, this.maxDelay, maxRetries);
    }

    protected long calculateDelay(double count) {
        return Math.min((long)((double)this.initialDelay * Math.pow(this.backoffFactor, count)), this.maxDelay);
    }

    private void sleepForRetries(int count) throws InterruptedException {
        long delay = this.calculateDelay(count);
        LOG.info("Retry [{}], sleeping for [{}] milliseconds", (Object)count, (Object)delay);
        Thread.sleep(delay);
    }

    private void checkMaxRetries(IOException exception, int count) throws BackoffException {
        if (this.maxRetries >= 0 && count >= this.maxRetries) {
            LOG.info("Number of retries [{}] is higher than configured maximum [{}]", (Object)count, (Object)this.maxRetries);
            throw new BackoffException(exception, count);
        }
    }

    @Override
    public <T> T call(int initialExceptionCount, IOException initialException, IOCallable<T> callable) throws BackoffException, InterruptedException {
        this.checkMaxRetries(initialException, initialExceptionCount);
        int count = initialExceptionCount;
        if (count > 0) {
            this.sleepForRetries(count);
        }
        while (true) {
            try {
                LOG.trace("Try [{}]", (Object)count);
                return callable.call();
            }
            catch (IOException e) {
                LOG.warn("Got [{}] on retry [{}]", new Object[]{e.getClass().getSimpleName(), count, e});
                this.checkMaxRetries(e, ++count);
                this.sleepForRetries(count);
                continue;
            }
            break;
        }
    }
}

