/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import javax.annotation.Nullable;
import org.zalando.fahrschein.AccessTokenProvider;
import org.zalando.fahrschein.AuthorizationProvider;
import org.zalando.fahrschein.AuthorizedRequestFactory;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.DefaultObjectMapper;
import org.zalando.fahrschein.ManagedCursorManager;
import org.zalando.fahrschein.NakadiClient;
import org.zalando.fahrschein.Preconditions;
import org.zalando.fahrschein.ProblemHandlingRequestFactory;
import org.zalando.fahrschein.http.api.RequestFactory;

public final class NakadiClientBuilder {
    private final URI baseUri;
    @Nullable
    private final ObjectMapper objectMapper;
    @Nullable
    private final AuthorizationProvider authorizationProvider;
    @Nullable
    private final RequestFactory clientHttpRequestFactory;
    @Nullable
    private final CursorManager cursorManager;

    NakadiClientBuilder(URI baseUri, RequestFactory requestFactory) {
        this(baseUri, DefaultObjectMapper.INSTANCE, null, requestFactory, null);
    }

    private NakadiClientBuilder(URI baseUri, @Nullable ObjectMapper objectMapper, @Nullable AuthorizationProvider authorizationProvider, @Nullable RequestFactory clientHttpRequestFactory, @Nullable CursorManager cursorManager) {
        this.objectMapper = objectMapper;
        this.baseUri = Preconditions.checkNotNull(baseUri, "Base URI should not be null");
        this.authorizationProvider = authorizationProvider;
        this.clientHttpRequestFactory = clientHttpRequestFactory;
        this.cursorManager = cursorManager;
    }

    public NakadiClientBuilder withObjectMapper(ObjectMapper objectMapper) {
        return new NakadiClientBuilder(this.baseUri, objectMapper, this.authorizationProvider, this.clientHttpRequestFactory, this.cursorManager);
    }

    public NakadiClientBuilder withAccessTokenProvider(AccessTokenProvider accessTokenProvider) {
        return this.withAuthorizationProvider(accessTokenProvider);
    }

    public NakadiClientBuilder withAuthorizationProvider(AuthorizationProvider authorizationProvider) {
        return new NakadiClientBuilder(this.baseUri, this.objectMapper, authorizationProvider, this.clientHttpRequestFactory, this.cursorManager);
    }

    public NakadiClientBuilder withCursorManager(CursorManager cursorManager) {
        return new NakadiClientBuilder(this.baseUri, this.objectMapper, this.authorizationProvider, this.clientHttpRequestFactory, cursorManager);
    }

    static RequestFactory wrapClientHttpRequestFactory(RequestFactory delegate, @Nullable AuthorizationProvider authorizationProvider) {
        Object requestFactory = new ProblemHandlingRequestFactory(delegate);
        if (authorizationProvider != null) {
            requestFactory = new AuthorizedRequestFactory((RequestFactory)requestFactory, authorizationProvider);
        }
        return requestFactory;
    }

    public NakadiClient build() {
        RequestFactory clientHttpRequestFactory = NakadiClientBuilder.wrapClientHttpRequestFactory(this.clientHttpRequestFactory, this.authorizationProvider);
        CursorManager cursorManager = this.cursorManager != null ? this.cursorManager : new ManagedCursorManager(this.baseUri, clientHttpRequestFactory, true);
        ObjectMapper objectMapper = this.objectMapper != null ? this.objectMapper : DefaultObjectMapper.INSTANCE;
        return new NakadiClient(this.baseUri, clientHttpRequestFactory, objectMapper, cursorManager);
    }
}

