/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class StreamParameters {
    private static final int DEFAULT_BATCH_LIMIT = 1;
    @Nullable
    private final Integer batchLimit;
    @Nullable
    private final Integer streamLimit;
    @Nullable
    private final Integer batchFlushTimeout;
    @Nullable
    private final Integer streamTimeout;
    @Nullable
    private final Integer streamKeepAliveLimit;
    @Nullable
    private final Integer maxUncommittedEvents;
    @Nullable
    private final Integer commitTimeout;

    private StreamParameters(@Nullable Integer batchLimit, @Nullable Integer streamLimit, @Nullable Integer batchFlushTimeout, @Nullable Integer streamTimeout, @Nullable Integer streamKeepAliveLimit, @Nullable Integer maxUncommittedEvents, @Nullable Integer commitTimeout) {
        this.batchLimit = batchLimit;
        this.streamLimit = streamLimit;
        this.batchFlushTimeout = batchFlushTimeout;
        this.streamTimeout = streamTimeout;
        this.streamKeepAliveLimit = streamKeepAliveLimit;
        this.maxUncommittedEvents = maxUncommittedEvents;
        this.commitTimeout = commitTimeout;
    }

    public StreamParameters() {
        this(null, null, null, null, null, null, null);
    }

    String toQueryString() {
        ArrayList<String> params = new ArrayList<String>(6);
        if (this.batchLimit != null) {
            params.add("batch_limit=" + this.batchLimit);
        }
        if (this.streamLimit != null) {
            params.add("stream_limit=" + this.streamLimit);
        }
        if (this.batchFlushTimeout != null) {
            params.add("batch_flush_timeout=" + this.batchFlushTimeout);
        }
        if (this.streamTimeout != null) {
            params.add("stream_timeout=" + this.streamTimeout);
        }
        if (this.streamKeepAliveLimit != null) {
            params.add("stream_keep_alive_limit=" + this.streamKeepAliveLimit);
        }
        if (this.maxUncommittedEvents != null) {
            params.add("max_uncommitted_events=" + this.maxUncommittedEvents);
        }
        if (this.commitTimeout != null) {
            params.add("commit_timeout=" + this.commitTimeout);
        }
        return params.stream().collect(Collectors.joining("&"));
    }

    public StreamParameters withBatchLimit(int batchLimit) throws IllegalArgumentException {
        if (this.streamLimit != null && this.streamLimit < batchLimit) {
            throw new IllegalArgumentException("streamLimit is lower than batch_limit.");
        }
        if (batchLimit < 1) {
            throw new IllegalArgumentException("batch_limit can't be lower than 1.");
        }
        return new StreamParameters(batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.maxUncommittedEvents, this.commitTimeout);
    }

    public StreamParameters withStreamLimit(int streamLimit) throws IllegalArgumentException {
        if (this.batchLimit != null && this.batchLimit > streamLimit) {
            throw new IllegalArgumentException("streamLimit is lower than batch_limit.");
        }
        return new StreamParameters(this.batchLimit, streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.maxUncommittedEvents, this.commitTimeout);
    }

    public StreamParameters withBatchFlushTimeout(int batchFlushTimeout) throws IllegalArgumentException {
        if (this.streamTimeout != null && this.streamTimeout < batchFlushTimeout) {
            throw new IllegalArgumentException("stream_timeout is lower than batch_flush_timeout.");
        }
        return new StreamParameters(this.batchLimit, this.streamLimit, batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.maxUncommittedEvents, this.commitTimeout);
    }

    public StreamParameters withStreamTimeout(int streamTimeout) throws IllegalArgumentException {
        if (this.batchFlushTimeout != null && this.batchFlushTimeout > streamTimeout) {
            throw new IllegalArgumentException("stream_timeout is lower than batch_flush_timeout.");
        }
        return new StreamParameters(this.batchLimit, this.streamLimit, this.batchFlushTimeout, streamTimeout, this.streamKeepAliveLimit, this.maxUncommittedEvents, this.commitTimeout);
    }

    public StreamParameters withCommitTimeout(int commitTimeout) {
        return new StreamParameters(this.batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.maxUncommittedEvents, commitTimeout);
    }

    public StreamParameters withStreamKeepAliveLimit(int streamKeepAliveLimit) {
        return new StreamParameters(this.batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, streamKeepAliveLimit, this.maxUncommittedEvents, this.commitTimeout);
    }

    public StreamParameters withMaxUncommittedEvents(int maxUncommittedEvents) {
        return new StreamParameters(this.batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, maxUncommittedEvents, this.commitTimeout);
    }

    public Optional<Integer> getBatchLimit() {
        return Optional.ofNullable(this.batchLimit);
    }

    public Optional<Integer> getStreamLimit() {
        return Optional.ofNullable(this.streamLimit);
    }

    public Optional<Integer> getBatchFlushTimeout() {
        return Optional.ofNullable(this.batchFlushTimeout);
    }

    public Optional<Integer> getStreamTimeout() {
        return Optional.ofNullable(this.streamTimeout);
    }

    public Optional<Integer> getStreamKeepAliveLimit() {
        return Optional.ofNullable(this.streamKeepAliveLimit);
    }

    public Optional<Integer> getMaxUncommittedEvents() {
        return Optional.ofNullable(this.maxUncommittedEvents);
    }

    public Optional<Integer> getCommitTimeout() {
        return Optional.ofNullable(this.commitTimeout);
    }
}

