/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.AuthorizationProvider;
import org.zalando.fahrschein.CursorCommitException;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.DefaultObjectMapper;
import org.zalando.fahrschein.IOProblem;
import org.zalando.fahrschein.NakadiClientBuilder;
import org.zalando.fahrschein.domain.Cursor;
import org.zalando.fahrschein.domain.Subscription;
import org.zalando.fahrschein.http.api.ContentType;
import org.zalando.fahrschein.http.api.Request;
import org.zalando.fahrschein.http.api.RequestFactory;
import org.zalando.fahrschein.http.api.Response;

public class ManagedCursorManager
implements CursorManager {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedCursorManager.class);
    private final URI baseUri;
    private final RequestFactory clientHttpRequestFactory;
    private final ObjectMapper objectMapper;
    private final Map<String, SubscriptionStream> streams;

    public ManagedCursorManager(URI baseUri, RequestFactory clientHttpRequestFactory, AuthorizationProvider authorizationProvider) {
        this(baseUri, NakadiClientBuilder.wrapClientHttpRequestFactory(clientHttpRequestFactory, authorizationProvider), true);
    }

    public ManagedCursorManager(URI baseUri, RequestFactory clientHttpRequestFactory) {
        this(baseUri, NakadiClientBuilder.wrapClientHttpRequestFactory(clientHttpRequestFactory, null), true);
    }

    ManagedCursorManager(URI baseUri, RequestFactory clientHttpRequestFactory, boolean clientHttpRequestFactoryIsAlreadyWrapped) {
        this.baseUri = baseUri;
        this.clientHttpRequestFactory = clientHttpRequestFactory;
        this.objectMapper = DefaultObjectMapper.INSTANCE;
        this.streams = new ConcurrentHashMap<String, SubscriptionStream>();
    }

    @Override
    public void addSubscription(Subscription subscription) {
        for (String eventName : subscription.getEventTypes()) {
            LOG.debug("Adding subscription [{}] to event [{}]", (Object)subscription.getId(), (Object)eventName);
            this.streams.put(eventName, new SubscriptionStream(eventName, subscription.getId()));
        }
    }

    @Override
    public void addStreamId(Subscription subscription, String streamId) {
        for (String eventName : subscription.getEventTypes()) {
            LOG.debug("Adding stream id [{}] for subscription [{}] to event [{}]", new Object[]{streamId, subscription.getId(), eventName});
            this.streams.get(eventName).setStreamId(streamId);
        }
    }

    @Override
    public void onSuccess(String eventName, Cursor cursor) throws IOException, CursorCommitException {
        block17: {
            SubscriptionStream stream = this.streams.get(eventName);
            String subscriptionId = stream.getSubscriptionId();
            URI subscriptionUrl = this.baseUri.resolve(String.format("/subscriptions/%s/cursors", subscriptionId));
            LOG.debug("Committing cursors for subscription [{}] to event [{}] in partition [{}] with offset [{}]", new Object[]{subscriptionId, stream.getEventName(), cursor.getPartition(), cursor.getOffset()});
            Request request = this.clientHttpRequestFactory.createRequest(subscriptionUrl, "POST");
            request.getHeaders().setContentType(ContentType.APPLICATION_JSON);
            request.getHeaders().put("X-Nakadi-StreamId", stream.getStreamId());
            try (OutputStream os = request.getBody();){
                this.objectMapper.writeValue(os, (Object)new CursorWrapper(Collections.singletonList(cursor)));
            }
            try (Response response = request.execute();){
                int status = response.getStatusCode();
                if (status == 204) {
                    LOG.debug("Successfully committed cursor for subscription [{}] to event [{}] in partition [{}] with offset [{}]", new Object[]{subscriptionId, eventName, cursor.getPartition(), cursor.getOffset()});
                    break block17;
                }
                if (status == 200) {
                    LOG.warn("Cursor for subscription [{}] to event [{}] in partition [{}] with offset [{}] was already committed", new Object[]{subscriptionId, eventName, cursor.getPartition(), cursor.getOffset()});
                    break block17;
                }
                throw new CursorCommitException(status, cursor, subscriptionId, this.inputStreamToString(response.getBody()));
            }
            catch (IOProblem e) {
                throw new CursorCommitException(e.getStatusCode(), cursor, subscriptionId, e);
            }
        }
    }

    private String inputStreamToString(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
    }

    @Override
    public void onSuccess(String eventName, List<Cursor> cursors) throws IOException {
        for (Cursor cursor : cursors) {
            this.onSuccess(eventName, cursor);
        }
    }

    @Override
    public Collection<Cursor> getCursors(String eventName) throws IOException {
        SubscriptionStream stream = this.streams.get(eventName);
        URI subscriptionUrl = this.baseUri.resolve(String.format("/subscriptions/%s/cursors", stream.getSubscriptionId()));
        Request request = this.clientHttpRequestFactory.createRequest(subscriptionUrl, "GET");
        try (Response response = request.execute();){
            List<Cursor> list;
            block12: {
                InputStream is = response.getBody();
                try {
                    CursorWrapper cursorWrapper = (CursorWrapper)this.objectMapper.readValue(is, CursorWrapper.class);
                    list = cursorWrapper.getItems();
                    if (is == null) break block12;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return list;
        }
    }

    static final class CursorWrapper {
        private final List<Cursor> items;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        CursorWrapper(@JsonProperty(value="items") List<Cursor> items) {
            this.items = items;
        }

        public List<Cursor> getItems() {
            return this.items;
        }
    }

    static final class SubscriptionStream {
        private final String eventName;
        private final String subscriptionId;
        private String streamId;

        SubscriptionStream(String eventName, String subscriptionId) {
            this.eventName = eventName;
            this.subscriptionId = subscriptionId;
        }

        String getEventName() {
            return this.eventName;
        }

        String getSubscriptionId() {
            return this.subscriptionId;
        }

        String getStreamId() {
            return this.streamId;
        }

        void setStreamId(String streamId) {
            this.streamId = streamId;
        }
    }
}

