/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.zalando.fahrschein.BackoffStrategy;
import org.zalando.fahrschein.BatchHandler;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.DefaultBatchHandler;
import org.zalando.fahrschein.EqualJitterBackoffStrategy;
import org.zalando.fahrschein.EventReader;
import org.zalando.fahrschein.IORunnable;
import org.zalando.fahrschein.Listener;
import org.zalando.fahrschein.MappingEventReader;
import org.zalando.fahrschein.MetricsCollector;
import org.zalando.fahrschein.NakadiReader;
import org.zalando.fahrschein.NoMetricsCollector;
import org.zalando.fahrschein.OffsetComparator;
import org.zalando.fahrschein.StreamBuilder;
import org.zalando.fahrschein.StreamParameters;
import org.zalando.fahrschein.domain.Cursor;
import org.zalando.fahrschein.domain.Lock;
import org.zalando.fahrschein.domain.Partition;
import org.zalando.fahrschein.domain.Subscription;
import org.zalando.fahrschein.http.api.RequestFactory;

class StreamBuilders {
    StreamBuilders() {
    }

    static class LowLevelStreamBuilderImpl
    extends AbstractStreamBuilder
    implements StreamBuilder.LowLevelStreamBuilder {
        private final String eventName;
        private final Lock lock;

        LowLevelStreamBuilderImpl(URI baseUri, RequestFactory clientHttpRequestFactory, CursorManager cursorManager, ObjectMapper objectMapper, String eventName) {
            this(baseUri, clientHttpRequestFactory, cursorManager, objectMapper, null, null, null, null, eventName, null);
        }

        private LowLevelStreamBuilderImpl(URI baseUri, RequestFactory clientHttpRequestFactory, CursorManager cursorManager, ObjectMapper objectMapper, @Nullable BackoffStrategy backoffStrategy, @Nullable StreamParameters streamParameters, @Nullable BatchHandler batchHandler, @Nullable MetricsCollector metricsCollector, String eventName, @Nullable Lock lock) {
            super(baseUri, clientHttpRequestFactory, cursorManager, objectMapper, backoffStrategy, streamParameters, batchHandler, metricsCollector);
            this.eventName = eventName;
            this.lock = lock;
        }

        @Override
        protected URI getURI(String queryString) {
            return this.baseUri.resolve(String.format("/event-types/%s/events?%s", this.eventName, queryString));
        }

        @Override
        protected Set<String> getEventNames() {
            return Collections.singleton(this.eventName);
        }

        @Override
        protected Optional<Subscription> getSubscription() {
            return Optional.empty();
        }

        @Override
        protected Optional<Lock> getLock() {
            return Optional.ofNullable(this.lock);
        }

        @Override
        public StreamBuilder.LowLevelStreamBuilder withBackoffStrategy(BackoffStrategy backoffStrategy) {
            return new LowLevelStreamBuilderImpl(this.baseUri, this.requestFactory, this.cursorManager, this.objectMapper, backoffStrategy, this.streamParameters, this.batchHandler, this.metricsCollector, this.eventName, this.lock);
        }

        @Override
        public StreamBuilder.LowLevelStreamBuilder withMetricsCollector(MetricsCollector metricsCollector) {
            return new LowLevelStreamBuilderImpl(this.baseUri, this.requestFactory, this.cursorManager, this.objectMapper, this.backoffStrategy, this.streamParameters, this.batchHandler, metricsCollector, this.eventName, this.lock);
        }

        @Override
        public StreamBuilder.LowLevelStreamBuilder withBatchHandler(BatchHandler batchHandler) {
            return new LowLevelStreamBuilderImpl(this.baseUri, this.requestFactory, this.cursorManager, this.objectMapper, this.backoffStrategy, this.streamParameters, batchHandler, this.metricsCollector, this.eventName, this.lock);
        }

        @Override
        public StreamBuilder.LowLevelStreamBuilder withStreamParameters(StreamParameters streamParameters) {
            return new LowLevelStreamBuilderImpl(this.baseUri, this.requestFactory, this.cursorManager, this.objectMapper, this.backoffStrategy, streamParameters, this.batchHandler, this.metricsCollector, this.eventName, this.lock);
        }

        @Override
        public StreamBuilder.LowLevelStreamBuilder withObjectMapper(ObjectMapper objectMapper) {
            return new LowLevelStreamBuilderImpl(this.baseUri, this.requestFactory, this.cursorManager, objectMapper, this.backoffStrategy, this.streamParameters, this.batchHandler, this.metricsCollector, this.eventName, this.lock);
        }

        @Override
        public StreamBuilder.LowLevelStreamBuilder withLock(Lock lock) {
            return new LowLevelStreamBuilderImpl(this.baseUri, this.requestFactory, this.cursorManager, this.objectMapper, this.backoffStrategy, this.streamParameters, this.batchHandler, this.metricsCollector, this.eventName, lock);
        }

        @Override
        public StreamBuilder.LowLevelStreamBuilder readFromBegin(List<Partition> partitions) throws IOException {
            List<Cursor> cursors = partitions.stream().map(p -> new Cursor(p.getPartition(), "BEGIN")).collect(Collectors.toList());
            this.cursorManager.onSuccess(this.eventName, cursors);
            return this;
        }

        @Override
        public StreamBuilder.LowLevelStreamBuilder readFromNewestAvailableOffset(List<Partition> partitions) throws IOException {
            List<Cursor> cursors = partitions.stream().map(p -> new Cursor(p.getPartition(), p.getNewestAvailableOffset())).collect(Collectors.toList());
            this.cursorManager.onSuccess(this.eventName, cursors);
            return this;
        }

        @Override
        public StreamBuilder.LowLevelStreamBuilder skipUnavailableOffsets(List<Partition> partitions) throws IOException {
            Map cursorsByPartition = this.cursorManager.getCursors(this.eventName).stream().collect(Collectors.toMap(Cursor::getPartition, Function.identity()));
            List<Cursor> cursors = partitions.stream().filter(p -> LowLevelStreamBuilderImpl.isNoLongerAvailable(cursorsByPartition, p)).map(p -> new Cursor(p.getPartition(), "BEGIN")).collect(Collectors.toList());
            if (!cursors.isEmpty()) {
                this.cursorManager.onSuccess(this.eventName, cursors);
            }
            return this;
        }

        private static boolean isNoLongerAvailable(Map<String, Cursor> cursorsByPartition, Partition p) {
            Cursor cursor = cursorsByPartition.get(p.getPartition());
            return cursor == null || !"BEGIN".equals(cursor.getOffset()) && OffsetComparator.INSTANCE.compare(cursor.getOffset(), p.getOldestAvailableOffset()) < 0;
        }
    }

    static class SubscriptionStreamBuilderImpl
    extends AbstractStreamBuilder
    implements StreamBuilder.SubscriptionStreamBuilder {
        private final Subscription subscription;

        SubscriptionStreamBuilderImpl(URI baseUri, RequestFactory clientHttpRequestFactory, CursorManager cursorManager, ObjectMapper objectMapper, Subscription subscription) {
            this(baseUri, clientHttpRequestFactory, cursorManager, objectMapper, null, null, null, null, subscription);
        }

        private SubscriptionStreamBuilderImpl(URI baseUri, RequestFactory clientHttpRequestFactory, CursorManager cursorManager, ObjectMapper objectMapper, @Nullable BackoffStrategy backoffStrategy, @Nullable StreamParameters streamParameters, @Nullable BatchHandler batchHandler, @Nullable MetricsCollector metricsCollector, Subscription subscription) {
            super(baseUri, clientHttpRequestFactory, cursorManager, objectMapper, backoffStrategy, streamParameters, batchHandler, metricsCollector);
            this.subscription = subscription;
        }

        @Override
        protected URI getURI(String queryString) {
            return this.baseUri.resolve(String.format("/subscriptions/%s/events?%s", this.subscription.getId(), queryString));
        }

        @Override
        protected Set<String> getEventNames() {
            return this.subscription.getEventTypes();
        }

        @Override
        protected Optional<Subscription> getSubscription() {
            return Optional.of(this.subscription);
        }

        @Override
        protected Optional<Lock> getLock() {
            return Optional.empty();
        }

        @Override
        public StreamBuilder.SubscriptionStreamBuilder withBackoffStrategy(BackoffStrategy backoffStrategy) {
            return new SubscriptionStreamBuilderImpl(this.baseUri, this.requestFactory, this.cursorManager, this.objectMapper, backoffStrategy, this.streamParameters, this.batchHandler, this.metricsCollector, this.subscription);
        }

        @Override
        public StreamBuilder.SubscriptionStreamBuilder withBatchHandler(BatchHandler batchHandler) {
            return new SubscriptionStreamBuilderImpl(this.baseUri, this.requestFactory, this.cursorManager, this.objectMapper, this.backoffStrategy, this.streamParameters, batchHandler, this.metricsCollector, this.subscription);
        }

        @Override
        public StreamBuilder.SubscriptionStreamBuilder withMetricsCollector(MetricsCollector metricsCollector) {
            return new SubscriptionStreamBuilderImpl(this.baseUri, this.requestFactory, this.cursorManager, this.objectMapper, this.backoffStrategy, this.streamParameters, this.batchHandler, metricsCollector, this.subscription);
        }

        @Override
        public StreamBuilder.SubscriptionStreamBuilder withStreamParameters(StreamParameters streamParameters) {
            return new SubscriptionStreamBuilderImpl(this.baseUri, this.requestFactory, this.cursorManager, this.objectMapper, this.backoffStrategy, streamParameters, this.batchHandler, this.metricsCollector, this.subscription);
        }

        @Override
        public StreamBuilder.SubscriptionStreamBuilder withObjectMapper(ObjectMapper objectMapper) {
            return new SubscriptionStreamBuilderImpl(this.baseUri, this.requestFactory, this.cursorManager, objectMapper, this.backoffStrategy, this.streamParameters, this.batchHandler, this.metricsCollector, this.subscription);
        }
    }

    static abstract class AbstractStreamBuilder
    implements StreamBuilder {
        protected final URI baseUri;
        protected final RequestFactory requestFactory;
        protected final CursorManager cursorManager;
        protected final ObjectMapper objectMapper;
        @Nullable
        protected final BackoffStrategy backoffStrategy;
        @Nullable
        protected final StreamParameters streamParameters;
        @Nullable
        protected final BatchHandler batchHandler;
        @Nullable
        protected final MetricsCollector metricsCollector;

        protected AbstractStreamBuilder(URI baseUri, RequestFactory requestFactory, CursorManager cursorManager, ObjectMapper objectMapper, @Nullable BackoffStrategy backoffStrategy, @Nullable StreamParameters streamParameters, @Nullable BatchHandler batchHandler, @Nullable MetricsCollector metricsCollector) {
            this.baseUri = baseUri;
            this.requestFactory = requestFactory;
            this.cursorManager = cursorManager;
            this.backoffStrategy = backoffStrategy;
            this.objectMapper = objectMapper;
            this.streamParameters = streamParameters;
            this.batchHandler = batchHandler;
            this.metricsCollector = metricsCollector;
        }

        protected abstract URI getURI(String var1);

        protected abstract Set<String> getEventNames();

        protected abstract Optional<Subscription> getSubscription();

        protected abstract Optional<Lock> getLock();

        @Override
        public final <T> void listen(Class<T> eventClass, Listener<T> listener) throws IOException {
            this.runnable(eventClass, listener).run();
        }

        @Override
        public final <T> void listen(EventReader<T> eventReader, Listener<T> listener) throws IOException {
            this.runnable(eventReader, listener).run();
        }

        @Override
        public final <T> IORunnable runnable(EventReader<T> eventReader, Listener<T> listener) {
            StreamParameters streamParameters = this.streamParameters != null ? this.streamParameters : new StreamParameters();
            String queryString = streamParameters.toQueryString();
            URI uri = this.getURI(queryString);
            Set<String> eventNames = this.getEventNames();
            Optional<Subscription> subscription = this.getSubscription();
            Optional<Lock> lock = this.getLock();
            BackoffStrategy backoffStrategy = this.backoffStrategy != null ? this.backoffStrategy : new EqualJitterBackoffStrategy();
            MetricsCollector metricsCollector = this.metricsCollector != null ? this.metricsCollector : NoMetricsCollector.NO_METRICS_COLLECTOR;
            BatchHandler batchHandler = this.batchHandler != null ? this.batchHandler : DefaultBatchHandler.INSTANCE;
            return new NakadiReader<T>(uri, this.requestFactory, backoffStrategy, this.cursorManager, eventNames, subscription, lock, eventReader, listener, batchHandler, metricsCollector);
        }

        @Override
        public final <T> IORunnable runnable(Class<T> eventClass, Listener<T> listener) {
            MappingEventReader<T> eventReader = new MappingEventReader<T>(eventClass, this.objectMapper);
            return this.runnable(eventReader, listener);
        }
    }
}

