/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.zalando.fahrschein.IOProblem;

public class IOProblemDeserializer
extends JsonDeserializer<IOProblem> {
    public IOProblem deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode rootNode = (JsonNode)jp.getCodec().readTree(jp);
        String type = rootNode.get("type").asText();
        String title = rootNode.get("title").asText();
        int status = rootNode.get("status").asInt();
        JsonNode detailNode = rootNode.get("detail");
        Optional<Object> detail = Optional.ofNullable(detailNode != null ? detailNode.asText(null) : null);
        JsonNode instanceNode = rootNode.get("instance");
        String instance = instanceNode != null ? instanceNode.asText(null) : null;
        try {
            Optional<URI> maybeInstance = instance != null ? Optional.of(new URI(instance)) : Optional.empty();
            return new IOProblem(new URI(type), title, status, detail, maybeInstance);
        }
        catch (URISyntaxException e) {
            throw new IOException("Cannot deserialize IOProblem json", e);
        }
    }
}

