/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.zalando.fahrschein.PartitionManager;

public class PersistentPartitionManager
implements PartitionManager {
    private final JdbcTemplate template;

    public PersistentPartitionManager(DataSource dataSource) throws IOException {
        this(new JdbcTemplate(dataSource));
    }

    public PersistentPartitionManager(JdbcTemplate template) throws IOException {
        this.template = template;
    }

    @Override
    public boolean lockPartition(String consumerName, String eventName, String partition, String lockedBy, long timeout, TimeUnit timeoutUnit) {
        String newLockedBy = (String)this.template.queryForObject("SELECT * FROM nakadi_cursor_partition_lock(?, ?, ?, ?, ?)", new Object[]{consumerName, eventName, partition, lockedBy, timeoutUnit.toMillis(timeout)}, String.class);
        return newLockedBy.equals(lockedBy);
    }

    @Override
    public void unlockPartition(String consumerName, String eventName, String partition, String lockedBy) {
        int rows = (Integer)this.template.queryForObject("SELECT * FROM nakadi_cursor_partition_unlock(?, ?, ?, ?)", new Object[]{consumerName, eventName, partition, lockedBy}, Integer.class);
        if (rows != 1) {
            throw new IllegalStateException("Unlock statement updated [" + rows + "] rows");
        }
    }
}

