/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.ObjectUtils;
import org.zalando.fahrschein.IOProblem;

public class ProblemHandlingClientHttpRequest
implements ClientHttpRequest {
    public static final MediaType APPLICATION_PROBLEM_JSON = new MediaType("application", "problem+json");
    private static final Set<MediaType> PROBLEM_CONTENT_TYPES = new HashSet<MediaType>(Arrays.asList(APPLICATION_PROBLEM_JSON));
    private static final URI DEFAULT_PROBLEM_TYPE = URI.create("about:blank");
    private final ClientHttpRequest clientHttpRequest;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ProblemHandlingClientHttpRequest(ClientHttpRequest clientHttpRequest) {
        this.clientHttpRequest = clientHttpRequest;
    }

    public ClientHttpResponse execute() throws IOException {
        ClientHttpResponse response = this.clientHttpRequest.execute();
        HttpStatus statusCode = response.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            MediaType contentType = response.getHeaders().getContentType();
            if (this.isProblemContentType(contentType)) {
                InputStream is = response.getBody();
                Throwable throwable = null;
                try {
                    try {
                        IOProblem problem = (IOProblem)this.objectMapper.readValue(is, IOProblem.class);
                        if (problem != null) {
                            throw problem;
                        }
                        throw new IOProblem(DEFAULT_PROBLEM_TYPE, statusCode.getReasonPhrase(), statusCode.value());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            is.close();
                        }
                    }
                    throw throwable3;
                }
            }
            throw new IOProblem(DEFAULT_PROBLEM_TYPE, statusCode.getReasonPhrase(), statusCode.value());
        }
        return response;
    }

    private boolean isProblemContentType(MediaType contentType) {
        if (contentType == null) {
            return false;
        }
        for (MediaType problemContentType : PROBLEM_CONTENT_TYPES) {
            if (!ObjectUtils.nullSafeEquals((Object)problemContentType.getType(), (Object)contentType.getType()) || !ObjectUtils.nullSafeEquals((Object)problemContentType.getSubtype(), (Object)contentType.getSubtype())) continue;
            return true;
        }
        return false;
    }

    public HttpMethod getMethod() {
        return this.clientHttpRequest.getMethod();
    }

    public URI getURI() {
        return this.clientHttpRequest.getURI();
    }

    public HttpHeaders getHeaders() {
        return this.clientHttpRequest.getHeaders();
    }

    public OutputStream getBody() throws IOException {
        return this.clientHttpRequest.getBody();
    }
}

