/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.zalando.fahrschein.domain.Cursor;
import org.zalando.fahrschein.domain.Partition;
import org.zalando.fahrschein.domain.Subscription;

public interface CursorManager {
    public void onSuccess(String var1, Cursor var2) throws IOException;

    public void onError(String var1, Cursor var2, Throwable var3) throws IOException;

    public Collection<Cursor> getCursors(String var1) throws IOException;

    default public void addSubscription(Subscription subscription) {
    }

    default public void fromNewestAvailableOffsets(String eventName, List<Partition> partitions) throws IOException {
        for (Partition partition : partitions) {
            this.onSuccess(eventName, new Cursor(partition.getPartition(), partition.getNewestAvailableOffset()));
        }
    }

    default public void fromOldestAvailableOffset(String eventName, List<Partition> partitions) throws IOException {
        for (Partition partition : partitions) {
            this.onSuccess(eventName, new Cursor(partition.getPartition(), "BEGIN"));
        }
    }

    default public void updatePartitions(String eventName, List<Partition> partitions) throws IOException {
        Map<String, Cursor> cursorsByPartition = this.getCursors(eventName).stream().collect(Collectors.toMap(Cursor::getPartition, c -> c));
        for (Partition partition : partitions) {
            Cursor cursor = cursorsByPartition.get(partition.getPartition());
            if (cursor != null && partition.isAvailable(cursor.getOffset())) continue;
            this.onSuccess(eventName, new Cursor(partition.getPartition(), "BEGIN"));
        }
    }
}

