/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.fahrschein.IOProblem;

public class ProblemHandlingClientHttpRequest
implements ClientHttpRequest {
    private static final MediaType APPLICATION_PROBLEM_JSON = new MediaType("application", "problem+json");
    private static final Set<MediaType> PROBLEM_CONTENT_TYPES = new HashSet<MediaType>(Arrays.asList(APPLICATION_PROBLEM_JSON, MediaType.APPLICATION_JSON));
    private static final URI DEFAULT_PROBLEM_TYPE = URI.create("about:blank");
    private final ClientHttpRequest clientHttpRequest;
    private final ObjectMapper objectMapper;

    public ProblemHandlingClientHttpRequest(ClientHttpRequest clientHttpRequest) {
        this.clientHttpRequest = clientHttpRequest;
        this.objectMapper = new ObjectMapper();
    }

    public ClientHttpResponse execute() throws IOException {
        ClientHttpResponse response = this.clientHttpRequest.execute();
        int statusCode = response.getRawStatusCode();
        if (statusCode >= 400) {
            String statusText = response.getStatusText();
            IOProblem.Status status = new IOProblem.Status(statusCode, statusText);
            MediaType contentType = response.getHeaders().getContentType();
            if (contentType != null && this.isProblemContentType(contentType)) {
                InputStream is = response.getBody();
                Throwable throwable = null;
                try {
                    try {
                        IOProblem problem = this.deserializeProblem(is, status);
                        if (problem != null) {
                            throw problem;
                        }
                        throw new IOProblem(DEFAULT_PROBLEM_TYPE, statusText, status);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            is.close();
                        }
                    }
                    throw throwable3;
                }
            }
            throw new IOProblem(DEFAULT_PROBLEM_TYPE, statusText, status);
        }
        return response;
    }

    private boolean isProblemContentType(MediaType contentType) {
        for (MediaType problemContentType : PROBLEM_CONTENT_TYPES) {
            if (!Objects.equals(problemContentType.getType(), contentType.getType()) || !Objects.equals(problemContentType.getSubtype(), contentType.getSubtype())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private IOProblem deserializeProblem(InputStream is, IOProblem.Status status) throws IOException {
        JsonNode rootNode = this.objectMapper.readTree(is);
        JsonNode typeNode = rootNode.get("type");
        JsonNode titleNode = rootNode.get("title");
        if (typeNode != null && titleNode != null) {
            String type = typeNode.asText();
            String title = titleNode.asText();
            JsonNode detailNode = rootNode.get("detail");
            String detail = detailNode == null ? null : detailNode.asText(null);
            JsonNode instanceNode = rootNode.get("instance");
            String instance = instanceNode == null ? null : instanceNode.asText(null);
            return new IOProblem(URI.create(type), title, status, detail, instance == null ? null : URI.create(instance));
        }
        JsonNode errorNode = rootNode.get("error");
        JsonNode descriptionNode = rootNode.get("error_description");
        if (errorNode != null && descriptionNode != null) {
            String error = errorNode.asText();
            String description = descriptionNode.asText();
            return new IOProblem(DEFAULT_PROBLEM_TYPE, error, status, description);
        }
        return null;
    }

    public HttpMethod getMethod() {
        return this.clientHttpRequest.getMethod();
    }

    public URI getURI() {
        return this.clientHttpRequest.getURI();
    }

    public HttpHeaders getHeaders() {
        return this.clientHttpRequest.getHeaders();
    }

    public OutputStream getBody() throws IOException {
        return this.clientHttpRequest.getBody();
    }
}

