/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.zalando.problem.Problem;

public class IOProblem
extends IOException
implements Problem {
    private final URI type;
    private final String title;
    private final Response.StatusType status;
    @Nullable
    private final String detail;
    @Nullable
    private final URI instance;

    public IOProblem(URI type, String title, Response.StatusType status, @Nullable String detail, @Nullable URI instance) {
        super(IOProblem.formatMessage(type, title, status.getStatusCode(), detail));
        this.type = type;
        this.title = title;
        this.status = status;
        this.detail = detail;
        this.instance = instance;
    }

    public IOProblem(URI type, String title, Response.StatusType status, @Nullable String detail) {
        this(type, title, status, detail, null);
    }

    public IOProblem(URI type, String title, Response.StatusType status) {
        this(type, title, status, null, null);
    }

    private static String formatMessage(URI type, String title, int status, @Nullable String detail) {
        return String.format("Problem [%s] with status [%d]: [%s] [%s]", type, status, title, detail == null ? "" : detail);
    }

    public URI getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public Response.StatusType getStatus() {
        return this.status;
    }

    public Optional<String> getDetail() {
        return Optional.ofNullable(this.detail);
    }

    public Optional<URI> getInstance() {
        return Optional.ofNullable(this.instance);
    }

    static final class Status
    implements Response.StatusType {
        private final int statusCode;
        private final String reasonPhrase;

        Status(int statusCode, String reasonPhrase) {
            this.statusCode = statusCode;
            this.reasonPhrase = reasonPhrase;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public Response.Status.Family getFamily() {
            return Response.Status.Family.familyOf((int)this.statusCode);
        }

        public String getReasonPhrase() {
            return this.reasonPhrase;
        }
    }
}

