/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.zalando.fahrschein.PartitionManager;

public class InMemoryPartitionManager
implements PartitionManager {
    private final ConcurrentHashMap<LockKey, LockInfo> locks = new ConcurrentHashMap();

    @Override
    public boolean lockPartition(String consumerName, String eventName, String partition, String lockedBy, long timeout, TimeUnit timeoutUnit) {
        long now = System.currentTimeMillis();
        LockInfo tryLock = new LockInfo(lockedBy, now + timeoutUnit.toMillis(timeout));
        LockKey lockKey = new LockKey(consumerName, eventName, partition);
        LockInfo newLock = this.locks.compute(lockKey, (key, old) -> old == null || ((LockInfo)old).lockedUntil < now ? tryLock : old);
        return lockedBy.equals(newLock.lockedBy);
    }

    @Override
    public void unlockPartition(String consumerName, String eventName, String partition, String lockedBy) {
        LockKey lockKey = new LockKey(consumerName, eventName, partition);
        LockInfo newLock = this.locks.compute(lockKey, (key, old) -> old != null && ((LockInfo)old).lockedBy.equals(lockedBy) ? null : old);
        if (newLock != null) {
            throw new IllegalStateException("Consumer [" + consumerName + "] tried to unlock partition locked by [" + newLock.lockedBy + "] instead of [" + lockedBy + "]");
        }
    }

    static final class LockInfo {
        private final String lockedBy;
        private final long lockedUntil;

        LockInfo(String lockedBy, long lockedUntil) {
            this.lockedBy = lockedBy;
            this.lockedUntil = lockedUntil;
        }
    }

    static final class LockKey {
        private final String consumerName;
        private final String eventName;
        private final String partition;

        LockKey(String consumerName, String eventName, String partition) {
            this.consumerName = consumerName;
            this.eventName = eventName;
            this.partition = partition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LockKey lockKey = (LockKey)o;
            return Objects.equals(this.consumerName, lockKey.consumerName) && Objects.equals(this.eventName, lockKey.eventName) && Objects.equals(this.partition, lockKey.partition);
        }

        public int hashCode() {
            return Objects.hash(this.consumerName, this.eventName, this.partition);
        }
    }
}

