/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;

public class StreamParameters {
    @Nullable
    private final Integer batchLimit;
    @Nullable
    private final Integer streamLimit;
    @Nullable
    private final Integer batchFlushTimeout;
    @Nullable
    private final Integer streamTimeout;
    @Nullable
    private final Integer streamKeepAliveLimit;
    @Nullable
    private final Integer windowSize;
    @Nullable
    private final Integer commitTimeout;

    private StreamParameters(Integer batchLimit, Integer streamLimit, Integer batchFlushTimeout, Integer streamTimeout, Integer streamKeepAliveLimit, Integer windowSize, Integer commitTimeout) {
        this.batchLimit = batchLimit;
        this.streamLimit = streamLimit;
        this.batchFlushTimeout = batchFlushTimeout;
        this.streamTimeout = streamTimeout;
        this.streamKeepAliveLimit = streamKeepAliveLimit;
        this.windowSize = windowSize;
        this.commitTimeout = commitTimeout;
    }

    public StreamParameters() {
        this(null, null, null, null, null, null, null);
    }

    String toQueryString() {
        ArrayList<String> params = new ArrayList<String>(5);
        if (this.batchLimit != null) {
            params.add("batch_limit=" + this.batchLimit);
        }
        if (this.streamLimit != null) {
            params.add("stream_limit=" + this.streamLimit);
        }
        if (this.batchFlushTimeout != null) {
            params.add("batch_flush_timeout=" + this.batchFlushTimeout);
        }
        if (this.streamTimeout != null) {
            params.add("stream_timeout=" + this.streamTimeout);
        }
        if (this.streamKeepAliveLimit != null) {
            params.add("stream_keep_alive_limit=" + this.streamKeepAliveLimit);
        }
        if (this.windowSize != null) {
            params.add("window_size=" + this.windowSize);
        }
        if (this.commitTimeout != null) {
            params.add("commit_timeout=" + this.commitTimeout);
        }
        return Joiner.on((String)"&").join(params);
    }

    public StreamParameters withBatchLimit(int batchLimit) {
        return new StreamParameters(batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.windowSize, this.commitTimeout);
    }

    public StreamParameters withStreamLimit(int streamLimit) {
        return new StreamParameters(this.batchLimit, streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.windowSize, this.commitTimeout);
    }

    public StreamParameters withBatchFlushTimeout(int batchFlushTimeout) {
        return new StreamParameters(this.batchLimit, this.streamLimit, batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.windowSize, this.commitTimeout);
    }

    public StreamParameters withStreamTimeout(int streamTimeout) {
        return new StreamParameters(this.batchLimit, this.streamLimit, this.batchFlushTimeout, streamTimeout, this.streamKeepAliveLimit, this.windowSize, this.commitTimeout);
    }

    public StreamParameters withStreamKeepAliveLimit(int streamKeepAliveLimit) {
        return new StreamParameters(this.batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, streamKeepAliveLimit, this.windowSize, this.commitTimeout);
    }

    public StreamParameters withWindowSize(int windowSize) {
        return new StreamParameters(this.batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, windowSize, this.commitTimeout);
    }

    public StreamParameters withCommitTimeout(int commitTimeout) {
        return new StreamParameters(this.batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.windowSize, commitTimeout);
    }

    public Optional<Integer> getBatchLimit() {
        return Optional.ofNullable(this.batchLimit);
    }

    public Optional<Integer> getStreamLimit() {
        return Optional.ofNullable(this.streamLimit);
    }

    public Optional<Integer> getBatchFlushTimeout() {
        return Optional.ofNullable(this.batchFlushTimeout);
    }

    public Optional<Integer> getStreamTimeout() {
        return Optional.ofNullable(this.streamTimeout);
    }

    public Optional<Integer> getStreamKeepAliveLimit() {
        return Optional.ofNullable(this.streamKeepAliveLimit);
    }

    public Optional<Integer> getWindowSize() {
        return Optional.ofNullable(this.windowSize);
    }

    public Optional<Integer> getCommitTimeout() {
        return Optional.ofNullable(this.commitTimeout);
    }
}

