/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.redis;

import org.springframework.data.redis.connection.DefaultStringRedisConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.zalando.fahrschein.domain.Cursor;
import org.zalando.fahrschein.redis.CursorKeyRedisSerializer;
import org.zalando.fahrschein.redis.CursorRedisSerializer;
import org.zalando.fahrschein.redis.RedisCursorKey;

final class CursorRedisTemplate
extends RedisTemplate<RedisCursorKey, Cursor> {
    public CursorRedisTemplate() {
    }

    public CursorRedisTemplate(RedisConnectionFactory connectionFactory) {
        this();
        this.setConnectionFactory(connectionFactory);
        this.setKeySerializer(new CursorKeyRedisSerializer());
        CursorRedisSerializer valueSerializer = new CursorRedisSerializer();
        this.setDefaultSerializer(valueSerializer);
        this.setValueSerializer(valueSerializer);
        this.afterPropertiesSet();
    }

    protected RedisConnection preProcessConnection(RedisConnection connection, boolean existingConnection) {
        return new DefaultStringRedisConnection(connection);
    }
}

