/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.redis;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.domain.Cursor;
import org.zalando.fahrschein.redis.CursorRedisTemplate;
import org.zalando.fahrschein.redis.RedisCursorKey;

public class RedisCursorManager
implements CursorManager {
    private static final Logger LOG = LoggerFactory.getLogger(RedisCursorManager.class);
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private final CursorRedisTemplate redisTemplate;
    private final String consumerName;

    public RedisCursorManager(JedisConnectionFactory jedisConnectionFactory, String consumerName) {
        this.redisTemplate = new CursorRedisTemplate((RedisConnectionFactory)jedisConnectionFactory);
        this.consumerName = consumerName;
    }

    @Override
    public void onSuccess(String eventName, Cursor cursor) throws IOException {
        this.redisTemplate.opsForValue().set((Object)this.cursorKey(eventName, cursor.getPartition()), (Object)cursor);
    }

    @Override
    public void onError(String eventName, Cursor cursor, Throwable throwable) throws IOException {
        LOG.warn("Exception while processing events for [{}] on partition [{}] at offset [{}]. Don't update cursor.", new Object[]{eventName, cursor.getPartition(), cursor.getOffset(), throwable});
    }

    @Override
    public Collection<Cursor> getCursors(String eventName) throws IOException {
        RedisCursorKey pattern = new RedisCursorKey(this.consumerName, eventName, "*");
        Set keys = this.redisTemplate.keys(pattern);
        ArrayList<Cursor> cursors = new ArrayList<Cursor>(keys.size());
        for (RedisCursorKey key : keys) {
            Cursor cursor = (Cursor)this.redisTemplate.opsForValue().get((Object)key);
            cursors.add(cursor);
        }
        return cursors;
    }

    private RedisCursorKey cursorKey(String eventName, String partition) {
        return new RedisCursorKey(this.consumerName, eventName, partition);
    }
}

