/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.domain;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.zalando.fahrschein.domain.Partition;

@Immutable
public final class Lock {
    private final String eventName;
    private final String lockedBy;
    private final List<Partition> partitions;

    public Lock(String eventName, String lockedBy, List<Partition> partitions) {
        Preconditions.checkState((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"Locked partitions should not be empty");
        this.eventName = eventName;
        this.lockedBy = lockedBy;
        this.partitions = Collections.unmodifiableList(new ArrayList<Partition>(partitions));
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getLockedBy() {
        return this.lockedBy;
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }
}

