/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.jdbc;

import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.zalando.fahrschein.PartitionManager;
import org.zalando.fahrschein.domain.Lock;
import org.zalando.fahrschein.domain.Partition;

public class JdbcPartitionManager
implements PartitionManager {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcPartitionManager.class);
    private final JdbcTemplate template;
    private final String consumerName;
    private final String schemaPrefix;

    public JdbcPartitionManager(JdbcTemplate template, String consumerName, String schema) {
        Preconditions.checkState((schema != null && !schema.isEmpty() ? 1 : 0) != 0, (Object)"Schema name should not be null or empty");
        this.template = template;
        this.consumerName = consumerName;
        this.schemaPrefix = schema + ".";
    }

    public JdbcPartitionManager(JdbcTemplate template, String consumerName) {
        this.template = template;
        this.consumerName = consumerName;
        this.schemaPrefix = "";
    }

    public JdbcPartitionManager(DataSource dataSource, String consumerName, String schema) {
        this(new JdbcTemplate(dataSource), consumerName, schema);
    }

    public JdbcPartitionManager(DataSource dataSource, String consumerName) {
        this(new JdbcTemplate(dataSource), consumerName);
    }

    private LockedPartition getLockedPartition(ResultSet rs, int idx) throws SQLException {
        return new LockedPartition(rs.getString(1), rs.getString(2), rs.getString(3));
    }

    private String formatPartitionIds(List<Partition> partitions) {
        return partitions.stream().map(Partition::getPartition).collect(Collectors.joining(",", "{", "}"));
    }

    @Override
    @Transactional
    public Optional<Lock> lockPartitions(String eventName, List<Partition> partitions, String lockedBy) {
        String sql = String.format("SELECT * FROM %snakadi_partition_lock(?, ?, ?::text[], ?)", this.schemaPrefix);
        String partitionIds = this.formatPartitionIds(partitions);
        List lockedPartitions = this.template.query(sql, new Object[]{this.consumerName, eventName, partitionIds, lockedBy}, this::getLockedPartition);
        if (lockedPartitions.isEmpty()) {
            return Optional.empty();
        }
        Map<String, Partition> partitionsById = partitions.stream().collect(Collectors.toMap(Partition::getPartition, p -> p));
        List<Partition> collect = lockedPartitions.stream().map(lp -> (Partition)partitionsById.get(lp.partition)).collect(Collectors.toList());
        return Optional.of(new Lock(eventName, lockedBy, collect));
    }

    @Override
    @Transactional
    public void unlockPartitions(Lock lock) {
        String sql = String.format("SELECT * FROM %snakadi_partition_unlock(?, ?, ?::text[], ?)", this.schemaPrefix);
        String partitionIds = this.formatPartitionIds(lock.getPartitions());
        List unlockedPartitions = this.template.query(sql, new Object[]{this.consumerName, lock.getEventName(), partitionIds, lock.getLockedBy()}, this::getLockedPartition);
        if (unlockedPartitions.isEmpty()) {
            throw new IllegalStateException("Could not unlock [" + lock.getEventName() + "] by [" + lock.getLockedBy() + "]");
        }
    }

    static class LockedPartition {
        final String consumerName;
        final String eventName;
        final String partition;

        public LockedPartition(String consumerName, String eventName, String partition) {
            this.consumerName = consumerName;
            this.eventName = eventName;
            this.partition = partition;
        }
    }
}

