/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.zalando.fahrschein.BackoffStrategy;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.DefaultObjectMapper;
import org.zalando.fahrschein.ExponentialBackoffStrategy;
import org.zalando.fahrschein.Listener;
import org.zalando.fahrschein.NakadiReader;
import org.zalando.fahrschein.StreamBuilder;
import org.zalando.fahrschein.StreamParameters;
import org.zalando.fahrschein.domain.Lock;
import org.zalando.fahrschein.domain.Subscription;
import org.zalando.fahrschein.metrics.MetricsCollector;
import org.zalando.fahrschein.metrics.NoMetricsCollector;

class StreamBuilders {
    StreamBuilders() {
    }

    static class LowLevelStreamBuilderImpl
    extends AbstractStreamBuilder
    implements StreamBuilder.LowLevelStreamBuilder {
        private final String eventName;
        private final Lock lock;

        LowLevelStreamBuilderImpl(URI baseUri, ClientHttpRequestFactory clientHttpRequestFactory, CursorManager cursorManager, String eventName) {
            this(baseUri, clientHttpRequestFactory, cursorManager, null, null, null, null, eventName, null);
        }

        private LowLevelStreamBuilderImpl(URI baseUri, ClientHttpRequestFactory clientHttpRequestFactory, CursorManager cursorManager, @Nullable BackoffStrategy backoffStrategy, @Nullable ObjectMapper objectMapper, @Nullable StreamParameters streamParameters, @Nullable MetricsCollector metricsCollector, String eventName, @Nullable Lock lock) {
            super(baseUri, clientHttpRequestFactory, cursorManager, backoffStrategy, objectMapper, streamParameters, metricsCollector);
            this.eventName = eventName;
            this.lock = lock;
        }

        @Override
        protected URI getURI(String queryString) {
            return this.baseUri.resolve(String.format("/event-types/%s/events?%s", this.eventName, queryString));
        }

        @Override
        protected String getEventName() {
            return this.eventName;
        }

        @Override
        protected Optional<Subscription> getSubscription() {
            return Optional.empty();
        }

        @Override
        protected Optional<Lock> getLock() {
            return Optional.ofNullable(this.lock);
        }

        @Override
        public StreamBuilder.LowLevelStreamBuilder withBackoffStrategy(BackoffStrategy backoffStrategy) {
            return new LowLevelStreamBuilderImpl(this.baseUri, this.clientHttpRequestFactory, this.cursorManager, backoffStrategy, this.objectMapper, this.streamParameters, this.metricsCollector, this.eventName, this.lock);
        }

        @Override
        public StreamBuilder.LowLevelStreamBuilder withMetricsCollector(MetricsCollector metricsCollector) {
            return new LowLevelStreamBuilderImpl(this.baseUri, this.clientHttpRequestFactory, this.cursorManager, this.backoffStrategy, this.objectMapper, this.streamParameters, metricsCollector, this.eventName, this.lock);
        }

        @Override
        public StreamBuilder.LowLevelStreamBuilder withStreamParameters(StreamParameters streamParameters) {
            return new LowLevelStreamBuilderImpl(this.baseUri, this.clientHttpRequestFactory, this.cursorManager, this.backoffStrategy, this.objectMapper, streamParameters, this.metricsCollector, this.eventName, this.lock);
        }

        @Override
        public StreamBuilder withObjectMapper(ObjectMapper objectMapper) {
            return new LowLevelStreamBuilderImpl(this.baseUri, this.clientHttpRequestFactory, this.cursorManager, this.backoffStrategy, objectMapper, this.streamParameters, this.metricsCollector, this.eventName, this.lock);
        }

        @Override
        public StreamBuilder.LowLevelStreamBuilder withLock(Lock lock) {
            return new LowLevelStreamBuilderImpl(this.baseUri, this.clientHttpRequestFactory, this.cursorManager, this.backoffStrategy, this.objectMapper, this.streamParameters, this.metricsCollector, this.eventName, lock);
        }
    }

    static class SubscriptionStreamBuilderImpl
    extends AbstractStreamBuilder
    implements StreamBuilder.SubscriptionStreamBuilder {
        private final Subscription subscription;

        SubscriptionStreamBuilderImpl(URI baseUri, ClientHttpRequestFactory clientHttpRequestFactory, CursorManager cursorManager, Subscription subscription) {
            this(baseUri, clientHttpRequestFactory, cursorManager, subscription, null, null, null, null);
        }

        private SubscriptionStreamBuilderImpl(URI baseUri, ClientHttpRequestFactory clientHttpRequestFactory, CursorManager cursorManager, Subscription subscription, @Nullable BackoffStrategy backoffStrategy, @Nullable ObjectMapper objectMapper, @Nullable StreamParameters streamParameters, @Nullable MetricsCollector metricsCollector) {
            super(baseUri, clientHttpRequestFactory, cursorManager, backoffStrategy, objectMapper, streamParameters, metricsCollector);
            this.subscription = subscription;
        }

        @Override
        protected URI getURI(String queryString) {
            return this.baseUri.resolve(String.format("/subscriptions/%s/events?%s", this.subscription.getId(), queryString));
        }

        @Override
        protected String getEventName() {
            return this.subscription.getEventTypes().iterator().next();
        }

        @Override
        protected Optional<Subscription> getSubscription() {
            return Optional.of(this.subscription);
        }

        @Override
        protected Optional<Lock> getLock() {
            return Optional.empty();
        }

        @Override
        public StreamBuilder.SubscriptionStreamBuilder withBackoffStrategy(BackoffStrategy backoffStrategy) {
            return new SubscriptionStreamBuilderImpl(this.baseUri, this.clientHttpRequestFactory, this.cursorManager, this.subscription, backoffStrategy, this.objectMapper, this.streamParameters, this.metricsCollector);
        }

        @Override
        public StreamBuilder.SubscriptionStreamBuilder withMetricsCollector(MetricsCollector metricsCollector) {
            return new SubscriptionStreamBuilderImpl(this.baseUri, this.clientHttpRequestFactory, this.cursorManager, this.subscription, this.backoffStrategy, this.objectMapper, this.streamParameters, metricsCollector);
        }

        @Override
        public StreamBuilder.SubscriptionStreamBuilder withStreamParameters(StreamParameters streamParameters) {
            return new SubscriptionStreamBuilderImpl(this.baseUri, this.clientHttpRequestFactory, this.cursorManager, this.subscription, this.backoffStrategy, this.objectMapper, streamParameters, this.metricsCollector);
        }

        @Override
        public StreamBuilder withObjectMapper(ObjectMapper objectMapper) {
            return new SubscriptionStreamBuilderImpl(this.baseUri, this.clientHttpRequestFactory, this.cursorManager, this.subscription, this.backoffStrategy, objectMapper, this.streamParameters, this.metricsCollector);
        }
    }

    static abstract class AbstractStreamBuilder
    implements StreamBuilder {
        protected final URI baseUri;
        protected final ClientHttpRequestFactory clientHttpRequestFactory;
        protected final CursorManager cursorManager;
        @Nullable
        protected final BackoffStrategy backoffStrategy;
        @Nullable
        protected final ObjectMapper objectMapper;
        @Nullable
        protected final StreamParameters streamParameters;
        @Nullable
        protected final MetricsCollector metricsCollector;

        protected AbstractStreamBuilder(URI baseUri, ClientHttpRequestFactory clientHttpRequestFactory, CursorManager cursorManager, @Nullable BackoffStrategy backoffStrategy, @Nullable ObjectMapper objectMapper, @Nullable StreamParameters streamParameters, @Nullable MetricsCollector metricsCollector) {
            this.baseUri = baseUri;
            this.clientHttpRequestFactory = clientHttpRequestFactory;
            this.cursorManager = cursorManager;
            this.backoffStrategy = backoffStrategy;
            this.objectMapper = objectMapper;
            this.streamParameters = streamParameters;
            this.metricsCollector = metricsCollector;
        }

        protected abstract URI getURI(String var1);

        protected abstract String getEventName();

        protected abstract Optional<Subscription> getSubscription();

        protected abstract Optional<Lock> getLock();

        @Override
        public final <T> void listen(Class<T> eventClass, Listener<T> listener) throws IOException {
            StreamParameters streamParameters = Optional.ofNullable(this.streamParameters).orElseGet(StreamParameters::new);
            String queryString = streamParameters.toQueryString();
            URI uri = this.getURI(queryString);
            String eventName = this.getEventName();
            Optional<Subscription> subscription = this.getSubscription();
            Optional<Lock> lock = this.getLock();
            BackoffStrategy backoffStrategy = Optional.ofNullable(this.backoffStrategy).orElseGet(ExponentialBackoffStrategy::new);
            ObjectMapper objectMapper = Optional.ofNullable(this.objectMapper).orElse(DefaultObjectMapper.INSTANCE);
            MetricsCollector metricsCollector = Optional.ofNullable(this.metricsCollector).orElse(NoMetricsCollector.NO_METRICS_COLLECTOR);
            NakadiReader<T> nakadiReader = new NakadiReader<T>(uri, this.clientHttpRequestFactory, backoffStrategy, this.cursorManager, objectMapper, eventName, subscription, lock, eventClass, listener, metricsCollector);
            nakadiReader.run();
        }
    }
}

