/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.jdbc;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.Preconditions;
import org.zalando.fahrschein.domain.Cursor;
import org.zalando.fahrschein.domain.Partition;

public class JdbcCursorManager
implements CursorManager {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCursorManager.class);
    private final JdbcTemplate template;
    private final String consumerName;
    private final String schemaPrefix;

    public JdbcCursorManager(JdbcTemplate template, String consumerName, String schema) {
        Preconditions.checkState(schema != null && !schema.isEmpty(), "Schema name should not be null or empty");
        this.template = template;
        this.consumerName = consumerName;
        this.schemaPrefix = schema + ".";
    }

    public JdbcCursorManager(JdbcTemplate template, String consumerName) {
        this.template = template;
        this.consumerName = consumerName;
        this.schemaPrefix = "";
    }

    public JdbcCursorManager(DataSource dataSource, String consumerName, String schema) {
        this(new JdbcTemplate(dataSource), consumerName, schema);
    }

    public JdbcCursorManager(DataSource dataSource, String consumerName) {
        this(new JdbcTemplate(dataSource), consumerName);
    }

    @Override
    @Transactional
    public void onSuccess(String eventName, Cursor cursor) throws IOException {
        String sql = String.format("SELECT * FROM %snakadi_cursor_update(?, ?, ?, ?)", this.schemaPrefix);
        this.template.queryForObject(sql, new Object[]{this.consumerName, eventName, cursor.getPartition(), cursor.getOffset()}, Integer.class);
    }

    @Override
    public void onError(String eventName, Cursor cursor, Throwable throwable) {
        LOG.warn("Exception while processing events for [{}] on partition [{}] at offset [{}]", new Object[]{eventName, cursor.getPartition(), cursor.getOffset(), throwable});
    }

    @Override
    public Collection<Cursor> getCursors(String eventName) throws IOException {
        String sql = String.format("SELECT * FROM %snakadi_cursor_find_by_event_name(?, ?)", this.schemaPrefix);
        return this.template.query(sql, new Object[]{this.consumerName, eventName}, (resultSet, i) -> {
            String partition = resultSet.getString(2);
            String offset = resultSet.getString(3);
            return new Cursor(partition, offset);
        });
    }

    @Override
    @Transactional
    public void fromNewestAvailableOffsets(String eventName, List<Partition> partitions) throws IOException {
        CursorManager.super.fromNewestAvailableOffsets(eventName, partitions);
    }

    @Override
    @Transactional
    public void fromOldestAvailableOffset(String eventName, List<Partition> partitions) throws IOException {
        CursorManager.super.fromOldestAvailableOffset(eventName, partitions);
    }

    @Override
    @Transactional
    public void updatePartitions(String eventName, List<Partition> partitions) throws IOException {
        CursorManager.super.updatePartitions(eventName, partitions);
    }
}

