/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.net.URI;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.zalando.fahrschein.AccessTokenProvider;
import org.zalando.fahrschein.AuthorizedClientHttpRequestFactory;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.ManagedCursorManager;
import org.zalando.fahrschein.NakadiClient;
import org.zalando.fahrschein.Preconditions;
import org.zalando.fahrschein.ProblemHandlingClientHttpRequestFactory;

public final class NakadiClientBuilder {
    public static final int DEFAULT_CONNECT_TIMEOUT = 500;
    public static final int DEFAULT_READ_TIMEOUT = 60000;
    private final URI baseUri;
    @Nullable
    private final AccessTokenProvider accessTokenProvider;
    @Nullable
    private final ClientHttpRequestFactory clientHttpRequestFactory;
    @Nullable
    private final CursorManager cursorManager;

    NakadiClientBuilder(URI baseUri) {
        this(baseUri, null, null, null);
    }

    private NakadiClientBuilder(URI baseUri, @Nullable AccessTokenProvider accessTokenProvider, @Nullable ClientHttpRequestFactory clientHttpRequestFactory, @Nullable CursorManager cursorManager) {
        this.baseUri = Preconditions.checkNotNull(baseUri, "Base URI should not be null");
        this.accessTokenProvider = accessTokenProvider;
        this.clientHttpRequestFactory = clientHttpRequestFactory;
        this.cursorManager = cursorManager;
    }

    public NakadiClientBuilder withAccessTokenProvider(AccessTokenProvider accessTokenProvider) {
        return new NakadiClientBuilder(this.baseUri, accessTokenProvider, this.clientHttpRequestFactory, this.cursorManager);
    }

    public NakadiClientBuilder withClientHttpRequestFactory(ClientHttpRequestFactory clientHttpRequestFactory) {
        return new NakadiClientBuilder(this.baseUri, this.accessTokenProvider, clientHttpRequestFactory, this.cursorManager);
    }

    public NakadiClientBuilder withCursorManager(CursorManager cursorManager) {
        return new NakadiClientBuilder(this.baseUri, this.accessTokenProvider, this.clientHttpRequestFactory, cursorManager);
    }

    private ClientHttpRequestFactory defaultClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory requestFactoryDelegate = new SimpleClientHttpRequestFactory();
        requestFactoryDelegate.setConnectTimeout(500);
        requestFactoryDelegate.setReadTimeout(60000);
        Object requestFactory = new ProblemHandlingClientHttpRequestFactory((ClientHttpRequestFactory)requestFactoryDelegate);
        if (this.accessTokenProvider != null) {
            requestFactory = new AuthorizedClientHttpRequestFactory((ClientHttpRequestFactory)requestFactory, this.accessTokenProvider);
        }
        return requestFactory;
    }

    public NakadiClient build() {
        ClientHttpRequestFactory clientHttpRequestFactory = Optional.ofNullable(this.clientHttpRequestFactory).orElseGet(this::defaultClientHttpRequestFactory);
        CursorManager cursorManager = Optional.ofNullable(this.cursorManager).orElseGet(() -> new ManagedCursorManager(this.baseUri, clientHttpRequestFactory));
        return new NakadiClient(this.baseUri, clientHttpRequestFactory, cursorManager);
    }
}

