/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.domain;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SubscriptionRequest {
    private final String owningApplication;
    private final Set<String> eventTypes;
    private final String consumerGroup;
    private final Position readFrom;

    public SubscriptionRequest(String owningApplication, Set<String> eventTypes, String consumerGroup, Position readFrom) {
        this.owningApplication = owningApplication;
        this.eventTypes = Collections.unmodifiableSet(eventTypes == null ? Collections.emptySet() : new HashSet<String>(eventTypes));
        this.consumerGroup = consumerGroup;
        this.readFrom = readFrom;
    }

    public SubscriptionRequest(String owningApplication, Set<String> eventTypes, String consumerGroup) {
        this(owningApplication, eventTypes, consumerGroup, Position.END);
    }

    public String getOwningApplication() {
        return this.owningApplication;
    }

    public Set<String> getEventTypes() {
        return this.eventTypes;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public Position getReadFrom() {
        return this.readFrom;
    }

    public static enum Position {
        BEGIN("begin"),
        END("end");

        private final String value;

        private Position(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

