/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Cursor {
    private final String partition;
    private final String offset;
    @Nullable
    private final String eventType;
    @Nullable
    private final String cursorToken;

    @JsonCreator
    public Cursor(String partition, String offset, @Nullable String eventType, @Nullable String cursorToken) {
        this.partition = partition;
        this.offset = offset;
        this.eventType = eventType;
        this.cursorToken = cursorToken;
    }

    public Cursor(String partition, String offset, String eventType) {
        this.partition = partition;
        this.offset = offset;
        this.eventType = eventType;
        this.cursorToken = null;
    }

    public Cursor(String partition, String offset) {
        this.partition = partition;
        this.offset = offset;
        this.eventType = null;
        this.cursorToken = null;
    }

    public String getPartition() {
        return this.partition;
    }

    public String getOffset() {
        return this.offset;
    }

    @Nullable
    public String getEventType() {
        return this.eventType;
    }

    @Nullable
    public String getCursorToken() {
        return this.cursorToken;
    }

    public String toString() {
        return "Cursor{partition='" + this.partition + '\'' + ", offset='" + this.offset + '\'' + ", eventType='" + this.eventType + '\'' + ", cursorToken='" + this.cursorToken + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cursor cursor = (Cursor)o;
        return Objects.equals(this.partition, cursor.partition) && Objects.equals(this.offset, cursor.offset) && Objects.equals(this.eventType, cursor.eventType) && Objects.equals(this.cursorToken, cursor.cursorToken);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.offset, this.eventType, this.cursorToken);
    }
}

