/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;

public class IOProblem
extends IOException {
    private final URI type;
    private final String title;
    private final int statusCode;
    @Nullable
    private final String detail;
    @Nullable
    private final URI instance;

    public IOProblem(URI type, String title, int statusCode, @Nullable String detail, @Nullable URI instance) {
        super(IOProblem.formatMessage(type, title, statusCode, detail));
        this.type = type;
        this.title = title;
        this.statusCode = statusCode;
        this.detail = detail;
        this.instance = instance;
    }

    public IOProblem(URI type, String title, int statusCode, @Nullable String detail) {
        this(type, title, statusCode, detail, null);
    }

    public IOProblem(URI type, String title, int statusCode) {
        this(type, title, statusCode, null, null);
    }

    private static String formatMessage(URI type, String title, int status, @Nullable String detail) {
        return String.format(Locale.ENGLISH, "Problem [%s] with status [%d]: [%s] [%s]", type, status, title, detail == null ? "" : detail);
    }

    public URI getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Optional<String> getDetail() {
        return Optional.ofNullable(this.detail);
    }

    public Optional<URI> getInstance() {
        return Optional.ofNullable(this.instance);
    }
}

