/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.zalando.fahrschein.EventReader;
import org.zalando.fahrschein.JsonParserHelper;

public class MappingEventReader<T>
implements EventReader<T> {
    private final Class<T> eventClass;
    private final ObjectReader eventReader;

    public MappingEventReader(Class<T> eventClass, ObjectMapper objectMapper) {
        this.eventClass = eventClass;
        this.eventReader = objectMapper.reader().forType(eventClass);
    }

    @Override
    public List<T> read(JsonParser jsonParser) throws IOException {
        JsonParserHelper.expectToken(jsonParser, JsonToken.START_ARRAY);
        jsonParser.clearCurrentToken();
        MappingIterator eventIterator = this.eventReader.readValues(jsonParser);
        ArrayList<T> events = new ArrayList<T>();
        while (true) {
            try {
                while (eventIterator.hasNext()) {
                    events.add(this.eventClass.cast(eventIterator.next()));
                }
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof JsonMappingException) {
                    this.onMappingException((JsonMappingException)cause);
                    continue;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw e;
            }
            break;
        }
        return events;
    }

    protected void onMappingException(JsonMappingException exception) throws IOException {
        throw exception;
    }
}

