/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.domain;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Authorization {
    private final List<AuthorizationAttribute> admins;
    private final List<AuthorizationAttribute> readers;

    public Authorization(List<AuthorizationAttribute> admins, List<AuthorizationAttribute> readers) {
        this.admins = Collections.unmodifiableList(admins);
        this.readers = Collections.unmodifiableList(readers);
    }

    public List<AuthorizationAttribute> getAdmins() {
        return this.admins;
    }

    public List<AuthorizationAttribute> getReaders() {
        return this.readers;
    }

    @Immutable
    public static final class AuthorizationAttribute {
        public static final AuthorizationAttribute ANYONE = new AuthorizationAttribute("*", "*");
        private final String dataType;
        private final String value;

        public AuthorizationAttribute(String dataType, String value) {
            this.dataType = dataType;
            this.value = value;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AuthorizationAttribute)) {
                return false;
            }
            AuthorizationAttribute that = (AuthorizationAttribute)o;
            return this.dataType.equals(that.dataType) && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.dataType, this.value);
        }
    }
}

