/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Metadata {
    private final String eventType;
    private final String eid;
    private final String partition;
    private final String version;
    private final String publishedBy;
    private final OffsetDateTime occurredAt;
    private final OffsetDateTime receivedAt;
    private final String flowId;
    private final Map<String, String> spanCtx;

    @JsonCreator
    @Deprecated
    private Metadata(@JsonProperty(value="event_type") String eventType, @JsonProperty(value="eid") String eid, @JsonProperty(value="occurred_at") String occurredAt, @JsonProperty(value="partition") String partition, @JsonProperty(value="version") String version, @JsonProperty(value="published_by") String publishedBy, @JsonProperty(value="received_at") String receivedAt, @JsonProperty(value="flow_id") String flowId, @JsonProperty(value="span_ctx") Map<String, String> spanCtx) {
        this(eventType, eid, occurredAt == null ? null : OffsetDateTime.parse(occurredAt), partition, version, publishedBy, receivedAt == null ? null : OffsetDateTime.parse(receivedAt), flowId, spanCtx);
    }

    public Metadata(String eventType, String eid, OffsetDateTime occurredAt, String partition, String version, String publishedBy, OffsetDateTime receivedAt, String flowId) {
        this(eventType, eid, occurredAt, partition, version, publishedBy, receivedAt, flowId, null);
    }

    public Metadata(String eventType, String eid, OffsetDateTime occurredAt, String partition, String version, String publishedBy, OffsetDateTime receivedAt, String flowId, Map<String, String> spanCtx) {
        this.eventType = eventType;
        this.eid = eid;
        this.occurredAt = occurredAt;
        this.partition = partition;
        this.version = version;
        this.publishedBy = publishedBy;
        this.receivedAt = receivedAt;
        this.flowId = flowId;
        this.spanCtx = spanCtx == null ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, String>(spanCtx));
    }

    public Metadata(String eid, OffsetDateTime occurredAt) {
        this(null, eid, occurredAt, null, null, null, null, null, null);
    }

    public Metadata(String eid, OffsetDateTime occurredAt, String flowId, Map<String, String> spanCtx) {
        this(null, eid, occurredAt, null, null, null, null, flowId, spanCtx);
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEid() {
        return this.eid;
    }

    public OffsetDateTime getOccurredAt() {
        return this.occurredAt;
    }

    public String getPartition() {
        return this.partition;
    }

    public String getVersion() {
        return this.version;
    }

    public OffsetDateTime getReceivedAt() {
        return this.receivedAt;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public Map<String, String> getSpanCtx() {
        return this.spanCtx;
    }

    public String getPublishedBy() {
        return this.publishedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals(this.eventType, metadata.eventType) && Objects.equals(this.eid, metadata.eid) && Objects.equals(this.partition, metadata.partition) && Objects.equals(this.version, metadata.version) && Objects.equals(this.publishedBy, metadata.publishedBy) && Objects.equals(this.occurredAt, metadata.occurredAt) && Objects.equals(this.receivedAt, metadata.receivedAt) && Objects.equals(this.flowId, metadata.flowId) && Objects.equals(this.spanCtx, metadata.spanCtx);
    }

    public int hashCode() {
        return Objects.hash(this.eventType, this.eid, this.partition, this.version, this.publishedBy, this.occurredAt, this.receivedAt, this.flowId, this.spanCtx);
    }

    public String toString() {
        return "Metadata{eventType='" + this.eventType + "', eid='" + this.eid + "', occurredAt=" + this.occurredAt + ", partition='" + this.partition + "', version='" + this.version + "', publishedBy='" + this.publishedBy + "', receivedAt=" + this.receivedAt + ", flowId='" + this.flowId + "', spanCtx=" + this.spanCtx.toString() + "}";
    }
}

