/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import org.zalando.fahrschein.EventPersistenceException;
import org.zalando.fahrschein.Preconditions;
import org.zalando.fahrschein.PublishingRetryStrategy;
import org.zalando.fahrschein.domain.BatchItemResponse;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PublishingRetryStrategies implements PublishingRetryStrategy
{
    ALL{

        @Override
        public <T> List<T> getEventsForRetry(EventPersistenceException ex) {
            return ex.getInputEvents();
        }
    }
    ,
    FAILED_ONLY{

        @Override
        public <T> List<T> getEventsForRetry(EventPersistenceException ex) {
            Preconditions.checkArgument(ex.getInputEvents().size() == ex.getResponses().length, "Invalid number of responses from Nakadi. It has to match size of the input batch");
            List<Object> x = IntStream.range(0, ex.getResponses().length).filter(i -> BatchItemResponse.PublishingStatus.FAILED == ex.getResponses()[i].getPublishingStatus()).mapToObj(i -> ex.getInputEvents().get(i)).toList();
            return x;
        }
    }
    ,
    ALL_FROM_FIRST_FAILURE{

        @Override
        public <T> List<T> getEventsForRetry(EventPersistenceException ex) {
            Preconditions.checkArgument(ex.getInputEvents().size() == ex.getResponses().length, "Invalid number of responses from Nakadi. It has to match size of the input batch");
            OptionalInt firstFailure = IntStream.range(0, ex.getResponses().length).filter(i -> BatchItemResponse.PublishingStatus.FAILED == ex.getResponses()[i].getPublishingStatus()).findFirst();
            if (firstFailure.isEmpty()) {
                return Collections.emptyList();
            }
            return ex.getInputEvents().subList(firstFailure.getAsInt(), ex.getInputEvents().size());
        }
    }
    ,
    NONE{

        @Override
        public <T> List<T> getEventsForRetry(EventPersistenceException ex) {
            return Collections.emptyList();
        }
    };

}

