/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Locale;
import javax.annotation.Nullable;

class JsonParserHelper {
    private JsonParserHelper() {
    }

    static void expectToken(JsonParser jsonParser, JsonToken expectedToken) throws IOException {
        JsonToken token = jsonParser.nextToken();
        JsonParserHelper.expectToken(token, expectedToken);
    }

    static void expectToken(@Nullable JsonToken currentToken, JsonToken expectedToken) throws IOException {
        if (currentToken == null) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException("Thread was interrupted");
            }
            throw new EOFException("Stream was closed");
        }
        if (currentToken != expectedToken) {
            throw new IOException(String.format(Locale.ENGLISH, "Expected [%s] but got [%s]", expectedToken, currentToken));
        }
    }
}

