/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.zalando.fahrschein.AccessTokenProvider;
import org.zalando.fahrschein.AuthorizationProvider;
import org.zalando.fahrschein.AuthorizedRequestFactory;
import org.zalando.fahrschein.BackoffStrategy;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.DefaultObjectMapper;
import org.zalando.fahrschein.EventPublishingHandler;
import org.zalando.fahrschein.ManagedCursorManager;
import org.zalando.fahrschein.NakadiClient;
import org.zalando.fahrschein.NoBackoffStrategy;
import org.zalando.fahrschein.Preconditions;
import org.zalando.fahrschein.ProblemHandlingRequestFactory;
import org.zalando.fahrschein.PublishingRetryStrategies;
import org.zalando.fahrschein.UserAgentRequestFactory;
import org.zalando.fahrschein.http.api.RequestFactory;

public final class NakadiClientBuilder {
    private final URI baseUri;
    @Nullable
    private final ObjectMapper objectMapper;
    @Nullable
    private final AuthorizationProvider authorizationProvider;
    @Nullable
    private final RequestFactory clientHttpRequestFactory;
    @Nullable
    private final CursorManager cursorManager;
    @Nullable
    private final List<EventPublishingHandler> eventPublishingHandlers;
    private final BackoffStrategy backoffStrategy;
    private final PublishingRetryStrategies publishingRetryStrategy;

    NakadiClientBuilder(URI baseUri, RequestFactory requestFactory) {
        this(baseUri, DefaultObjectMapper.INSTANCE, null, requestFactory, null, Collections.emptyList(), null, null);
    }

    private NakadiClientBuilder(URI baseUri, @Nullable ObjectMapper objectMapper, @Nullable AuthorizationProvider authorizationProvider, @Nullable RequestFactory clientHttpRequestFactory, @Nullable CursorManager cursorManager, BackoffStrategy backoffStrategy, PublishingRetryStrategies publishingRetryStrategy) {
        this.objectMapper = objectMapper;
        this.baseUri = Preconditions.checkNotNull(baseUri, "Base URI should not be null");
        this.authorizationProvider = authorizationProvider;
        this.clientHttpRequestFactory = clientHttpRequestFactory;
        this.cursorManager = cursorManager;
        this.eventPublishingHandlers = new ArrayList<EventPublishingHandler>();
        this.backoffStrategy = backoffStrategy;
        this.publishingRetryStrategy = publishingRetryStrategy;
    }

    public NakadiClientBuilder(URI baseUri, @Nullable ObjectMapper objectMapper, @Nullable AuthorizationProvider authorizationProvider, @Nullable RequestFactory clientHttpRequestFactory, @Nullable CursorManager cursorManager, @Nullable List<EventPublishingHandler> eventPublishingHandlers, @Nullable BackoffStrategy backoffStrategy, PublishingRetryStrategies publishingRetryStrategy) {
        this.objectMapper = objectMapper;
        this.baseUri = Preconditions.checkNotNull(baseUri, "Base URI should not be null");
        this.authorizationProvider = authorizationProvider;
        this.clientHttpRequestFactory = clientHttpRequestFactory;
        this.cursorManager = cursorManager;
        this.eventPublishingHandlers = eventPublishingHandlers;
        this.backoffStrategy = backoffStrategy;
        this.publishingRetryStrategy = publishingRetryStrategy;
    }

    public NakadiClientBuilder withObjectMapper(ObjectMapper objectMapper) {
        return new NakadiClientBuilder(this.baseUri, objectMapper, this.authorizationProvider, this.clientHttpRequestFactory, this.cursorManager, this.backoffStrategy, this.publishingRetryStrategy);
    }

    public NakadiClientBuilder withAccessTokenProvider(AccessTokenProvider accessTokenProvider) {
        return this.withAuthorizationProvider(accessTokenProvider);
    }

    public NakadiClientBuilder withAuthorizationProvider(AuthorizationProvider authorizationProvider) {
        return new NakadiClientBuilder(this.baseUri, this.objectMapper, authorizationProvider, this.clientHttpRequestFactory, this.cursorManager, this.backoffStrategy, this.publishingRetryStrategy);
    }

    public NakadiClientBuilder withCursorManager(CursorManager cursorManager) {
        return new NakadiClientBuilder(this.baseUri, this.objectMapper, this.authorizationProvider, this.clientHttpRequestFactory, cursorManager, this.backoffStrategy, this.publishingRetryStrategy);
    }

    public NakadiClientBuilder withRequestHandlers(List<EventPublishingHandler> eventPublishingHandlers) {
        return new NakadiClientBuilder(this.baseUri, this.objectMapper, this.authorizationProvider, this.clientHttpRequestFactory, this.cursorManager, eventPublishingHandlers, this.backoffStrategy, this.publishingRetryStrategy);
    }

    public NakadiClientBuilder withRequestHandler(EventPublishingHandler eventPublishingHandler) {
        this.eventPublishingHandlers.add(eventPublishingHandler);
        return new NakadiClientBuilder(this.baseUri, this.objectMapper, this.authorizationProvider, this.clientHttpRequestFactory, this.cursorManager, this.eventPublishingHandlers, this.backoffStrategy, this.publishingRetryStrategy);
    }

    public NakadiClientBuilder withPublishingRetryAndBackoffStrategy(PublishingRetryStrategies publishingRetryStrategy, BackoffStrategy backoffStrategy) {
        return new NakadiClientBuilder(this.baseUri, this.objectMapper, this.authorizationProvider, this.clientHttpRequestFactory, this.cursorManager, this.eventPublishingHandlers, backoffStrategy, publishingRetryStrategy);
    }

    public NakadiClientBuilder disablePublishingRetry() {
        return new NakadiClientBuilder(this.baseUri, this.objectMapper, this.authorizationProvider, this.clientHttpRequestFactory, this.cursorManager, this.eventPublishingHandlers, new NoBackoffStrategy(), PublishingRetryStrategies.NONE);
    }

    static RequestFactory wrapClientHttpRequestFactory(RequestFactory delegate, @Nullable AuthorizationProvider authorizationProvider) {
        Object requestFactory = new ProblemHandlingRequestFactory(new UserAgentRequestFactory(delegate));
        if (authorizationProvider != null) {
            requestFactory = new AuthorizedRequestFactory((RequestFactory)requestFactory, authorizationProvider);
        }
        return requestFactory;
    }

    public NakadiClient build() {
        RequestFactory clientHttpRequestFactory = NakadiClientBuilder.wrapClientHttpRequestFactory(this.clientHttpRequestFactory, this.authorizationProvider);
        CursorManager cursorManager = this.cursorManager != null ? this.cursorManager : new ManagedCursorManager(this.baseUri, clientHttpRequestFactory, true);
        ObjectMapper objectMapper = this.objectMapper != null ? this.objectMapper : DefaultObjectMapper.INSTANCE;
        BackoffStrategy backoffStrategy = this.backoffStrategy != null ? this.backoffStrategy : new NoBackoffStrategy();
        PublishingRetryStrategies publishingRetryStrategy = this.publishingRetryStrategy != null ? this.publishingRetryStrategy : PublishingRetryStrategies.NONE;
        return new NakadiClient(this.baseUri, clientHttpRequestFactory, objectMapper, cursorManager, this.eventPublishingHandlers, backoffStrategy, publishingRetryStrategy);
    }
}

