/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.zalando.fahrschein.AccessTokenProvider;
import org.zalando.fahrschein.Preconditions;

public class PlatformAccessTokenProvider
implements AccessTokenProvider {
    private static final String TOKEN_SECRET_SUFFIX = "-token-secret";
    private static final String DEFAULT_CREDENTIALS_DIRECTORY = "/meta/credentials";
    private static final String DEFAULT_APPLICATION_NAME = "nakadi";
    private final Path directory;
    private final String name;

    public PlatformAccessTokenProvider(Path directory, String name) {
        this.directory = directory;
        this.name = name;
    }

    public PlatformAccessTokenProvider() {
        this(Paths.get(DEFAULT_CREDENTIALS_DIRECTORY, new String[0]), DEFAULT_APPLICATION_NAME);
    }

    public PlatformAccessTokenProvider(String name) {
        this(Paths.get(DEFAULT_CREDENTIALS_DIRECTORY, new String[0]), name);
    }

    @Override
    public String getAccessToken() throws IOException {
        Path filePath = this.directory.resolve(this.name + TOKEN_SECRET_SUFFIX);
        String token = new String(Files.readAllBytes(filePath), StandardCharsets.UTF_8);
        Preconditions.checkArgument(token.length() != 0, "Secret file cannot be empty");
        return token.trim();
    }
}

