/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class StreamParameters {
    @Nullable
    private final Integer batchLimit;
    @Nullable
    private final Integer streamLimit;
    @Nullable
    private final Integer batchFlushTimeout;
    @Nullable
    private final Integer streamTimeout;
    @Nullable
    private final Integer streamKeepAliveLimit;
    @Nullable
    private final Integer maxUncommittedEvents;
    @Nullable
    private final Integer commitTimeout;
    @Nullable
    private final Integer batchTimespan;

    private StreamParameters(@Nullable Integer batchLimit, @Nullable Integer streamLimit, @Nullable Integer batchFlushTimeout, @Nullable Integer streamTimeout, @Nullable Integer streamKeepAliveLimit, @Nullable Integer maxUncommittedEvents, @Nullable Integer commitTimeout, @Nullable Integer batchTimespan) {
        this.batchLimit = batchLimit;
        this.streamLimit = streamLimit;
        this.batchFlushTimeout = batchFlushTimeout;
        this.streamTimeout = streamTimeout;
        this.streamKeepAliveLimit = streamKeepAliveLimit;
        this.maxUncommittedEvents = maxUncommittedEvents;
        this.commitTimeout = commitTimeout;
        this.batchTimespan = batchTimespan;
    }

    public StreamParameters() {
        this(null, null, null, null, null, null, null, null);
    }

    String toQueryString() {
        ArrayList<CallSite> params = new ArrayList<CallSite>(8);
        if (this.batchLimit != null) {
            params.add((CallSite)((Object)("batch_limit=" + this.batchLimit)));
        }
        if (this.streamLimit != null) {
            params.add((CallSite)((Object)("stream_limit=" + this.streamLimit)));
        }
        if (this.batchFlushTimeout != null) {
            params.add((CallSite)((Object)("batch_flush_timeout=" + this.batchFlushTimeout)));
        }
        if (this.streamTimeout != null) {
            params.add((CallSite)((Object)("stream_timeout=" + this.streamTimeout)));
        }
        if (this.streamKeepAliveLimit != null) {
            params.add((CallSite)((Object)("stream_keep_alive_limit=" + this.streamKeepAliveLimit)));
        }
        if (this.maxUncommittedEvents != null) {
            params.add((CallSite)((Object)("max_uncommitted_events=" + this.maxUncommittedEvents)));
        }
        if (this.commitTimeout != null) {
            params.add((CallSite)((Object)("commit_timeout=" + this.commitTimeout)));
        }
        if (this.batchTimespan != null) {
            params.add((CallSite)((Object)("batch_timespan=" + this.batchTimespan)));
        }
        return params.stream().collect(Collectors.joining("&"));
    }

    public StreamParameters withBatchLimit(int batchLimit) throws IllegalArgumentException {
        return new StreamParameters(batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.maxUncommittedEvents, this.commitTimeout, this.batchTimespan);
    }

    public StreamParameters withStreamLimit(int streamLimit) throws IllegalArgumentException {
        return new StreamParameters(this.batchLimit, streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.maxUncommittedEvents, this.commitTimeout, this.batchTimespan);
    }

    public StreamParameters withBatchFlushTimeout(int batchFlushTimeout) throws IllegalArgumentException {
        return new StreamParameters(this.batchLimit, this.streamLimit, batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.maxUncommittedEvents, this.commitTimeout, this.batchTimespan);
    }

    public StreamParameters withStreamTimeout(int streamTimeout) throws IllegalArgumentException {
        return new StreamParameters(this.batchLimit, this.streamLimit, this.batchFlushTimeout, streamTimeout, this.streamKeepAliveLimit, this.maxUncommittedEvents, this.commitTimeout, this.batchTimespan);
    }

    public StreamParameters withCommitTimeout(int commitTimeout) {
        return new StreamParameters(this.batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.maxUncommittedEvents, commitTimeout, this.batchTimespan);
    }

    public StreamParameters withStreamKeepAliveLimit(int streamKeepAliveLimit) {
        return new StreamParameters(this.batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, streamKeepAliveLimit, this.maxUncommittedEvents, this.commitTimeout, this.batchTimespan);
    }

    public StreamParameters withMaxUncommittedEvents(int maxUncommittedEvents) {
        return new StreamParameters(this.batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, maxUncommittedEvents, this.commitTimeout, this.batchTimespan);
    }

    public StreamParameters withBatchTimespan(int batchTimespan) {
        return new StreamParameters(this.batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.maxUncommittedEvents, this.commitTimeout, batchTimespan);
    }

    public Optional<Integer> getBatchLimit() {
        return Optional.ofNullable(this.batchLimit);
    }

    public Optional<Integer> getStreamLimit() {
        return Optional.ofNullable(this.streamLimit);
    }

    public Optional<Integer> getBatchFlushTimeout() {
        return Optional.ofNullable(this.batchFlushTimeout);
    }

    public Optional<Integer> getStreamTimeout() {
        return Optional.ofNullable(this.streamTimeout);
    }

    public Optional<Integer> getStreamKeepAliveLimit() {
        return Optional.ofNullable(this.streamKeepAliveLimit);
    }

    public Optional<Integer> getMaxUncommittedEvents() {
        return Optional.ofNullable(this.maxUncommittedEvents);
    }

    public Optional<Integer> getCommitTimeout() {
        return Optional.ofNullable(this.commitTimeout);
    }

    public Optional<Integer> getBatchTimespan() {
        return Optional.ofNullable(this.batchTimespan);
    }
}

