/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fahrschein;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.BackoffException;
import org.zalando.fahrschein.BackoffStrategy;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.DefaultObjectMapper;
import org.zalando.fahrschein.EventPersistenceException;
import org.zalando.fahrschein.EventPublishingHandler;
import org.zalando.fahrschein.EventValidationException;
import org.zalando.fahrschein.ExceptionAwareCallable;
import org.zalando.fahrschein.ManagedCursorManager;
import org.zalando.fahrschein.NakadiClientBuilder;
import org.zalando.fahrschein.NoBackoffStrategy;
import org.zalando.fahrschein.Preconditions;
import org.zalando.fahrschein.PublishingRetryStrategies;
import org.zalando.fahrschein.PublishingRetryStrategy;
import org.zalando.fahrschein.StreamBuilder;
import org.zalando.fahrschein.StreamBuilders;
import org.zalando.fahrschein.SubscriptionBuilder;
import org.zalando.fahrschein.domain.Authorization;
import org.zalando.fahrschein.domain.Cursor;
import org.zalando.fahrschein.domain.Partition;
import org.zalando.fahrschein.domain.Subscription;
import org.zalando.fahrschein.domain.SubscriptionRequest;
import org.zalando.fahrschein.http.api.ContentType;
import org.zalando.fahrschein.http.api.Request;
import org.zalando.fahrschein.http.api.RequestFactory;
import org.zalando.fahrschein.http.api.Response;

public class NakadiClient {
    private static final Logger LOG = LoggerFactory.getLogger(NakadiClient.class);
    private static final TypeReference<List<Partition>> LIST_OF_PARTITIONS = new TypeReference<List<Partition>>(){};
    private final URI baseUri;
    private final RequestFactory requestFactory;
    private final ObjectMapper internalObjectMapper;
    private final ObjectMapper objectMapper;
    private final CursorManager cursorManager;
    private final LinkedList<EventPublishingHandler> eventPublishingHandlers;
    private final BackoffStrategy backoffStrategy;
    private final PublishingRetryStrategy publishingRetryStrategy;

    public static NakadiClientBuilder builder(URI baseUri, RequestFactory requestFactory) {
        return new NakadiClientBuilder(baseUri, requestFactory);
    }

    NakadiClient(URI baseUri, RequestFactory requestFactory, ObjectMapper objectMapper, CursorManager cursorManager, BackoffStrategy backoffStrategy, PublishingRetryStrategy publishingRetryStrategy) {
        this.baseUri = baseUri;
        this.requestFactory = requestFactory;
        this.objectMapper = objectMapper;
        this.publishingRetryStrategy = publishingRetryStrategy;
        this.internalObjectMapper = DefaultObjectMapper.INSTANCE;
        this.cursorManager = cursorManager;
        this.eventPublishingHandlers = new LinkedList();
        this.backoffStrategy = backoffStrategy;
    }

    NakadiClient(URI baseUri, RequestFactory requestFactory, ObjectMapper objectMapper, CursorManager cursorManager, List<EventPublishingHandler> eventPublishingHandlers, BackoffStrategy backoffStrategy, PublishingRetryStrategy publishingRetryStrategy) {
        this.baseUri = baseUri;
        this.requestFactory = requestFactory;
        this.objectMapper = objectMapper;
        this.internalObjectMapper = DefaultObjectMapper.INSTANCE;
        this.cursorManager = cursorManager;
        this.eventPublishingHandlers = new LinkedList<EventPublishingHandler>(eventPublishingHandlers);
        this.backoffStrategy = backoffStrategy;
        this.publishingRetryStrategy = publishingRetryStrategy;
    }

    public List<Partition> getPartitions(String eventName) throws IOException {
        URI uri = this.baseUri.resolve("/event-types/" + eventName + "/partitions");
        Request request = this.requestFactory.createRequest(uri, "GET");
        try (Response response = request.execute();){
            List list;
            block12: {
                InputStream is = response.getBody();
                try {
                    list = (List)this.internalObjectMapper.readValue(is, LIST_OF_PARTITIONS);
                    if (is == null) break block12;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void publish(String eventName, List<T> events) throws EventValidationException, EventPersistenceException, IOException {
        try {
            try {
                this.send(eventName, events);
            }
            catch (EventPersistenceException ex) {
                if (this.publishingRetryStrategy == PublishingRetryStrategies.NONE) {
                    throw ex;
                }
                Preconditions.checkArgument(!(this.backoffStrategy instanceof NoBackoffStrategy), "No backoffStrategy configured for retrying");
                ExceptionAwareCallable<Void> retryableOperation = (retryCount, exception) -> {
                    this.send(eventName, this.publishingRetryStrategy.getEventsForRetry(exception));
                    return null;
                };
                this.backoffStrategy.call(0, ex, retryableOperation);
            }
        }
        catch (Throwable t) {
            this.eventPublishingHandlers.descendingIterator().forEachRemaining(handler -> handler.onError(Collections.emptyList(), t));
            try {
                throw t;
            }
            catch (BackoffException e) {
                throw e.getCause();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.eventPublishingHandlers.descendingIterator().forEachRemaining(EventPublishingHandler::afterPublish);
        }
    }

    private <T> void send(String eventName, List<T> events) throws IOException {
        URI uri = this.baseUri.resolve(String.format(Locale.ENGLISH, "/event-types/%s/events", eventName));
        Request request = this.requestFactory.createRequest(uri, "POST");
        request.getHeaders().setContentType(ContentType.APPLICATION_JSON);
        try (OutputStream body = request.getBody();){
            this.objectMapper.writeValue(body, events);
        }
        try (Response response = null;){
            this.eventPublishingHandlers.forEach(handler -> handler.onPublish(eventName, events));
            response = request.execute();
            LOG.debug("Successfully published [{}] events for [{}]", (Object)events.size(), (Object)eventName);
        }
    }

    @Deprecated
    public Subscription subscribe(String applicationName, String eventName, String consumerGroup) throws IOException {
        return this.subscription(applicationName, eventName).withConsumerGroup(consumerGroup).subscribe();
    }

    public SubscriptionBuilder subscription(String applicationName, String eventName) throws IOException {
        return new SubscriptionBuilder(this, applicationName, Collections.singleton(eventName));
    }

    public SubscriptionBuilder subscription(String applicationName, Set<String> eventNames) throws IOException {
        return new SubscriptionBuilder(this, applicationName, eventNames);
    }

    public void deleteSubscription(String subscriptionId) throws IOException {
        Preconditions.checkArgument(!subscriptionId.isEmpty(), "Subscription ID cannot be empty.");
        URI uri = this.baseUri.resolve(String.format(Locale.ENGLISH, "/subscriptions/%s", subscriptionId));
        Request request = this.requestFactory.createRequest(uri, "DELETE");
        request.getHeaders().setContentType(ContentType.APPLICATION_JSON);
        try (Response response = request.execute();){
            int status = response.getStatusCode();
            if (status == 204) {
                LOG.debug("Successfully deleted subscription [{}]", (Object)subscriptionId);
            }
        }
    }

    Subscription subscribe(String applicationName, Set<String> eventNames, String subscriptionId) {
        Subscription subscription = new Subscription(subscriptionId, applicationName, eventNames);
        LOG.info("Using subscription ID [{}] for event {}", (Object)subscriptionId, eventNames);
        this.cursorManager.addSubscription(subscription);
        return subscription;
    }

    Subscription subscribe(String applicationName, Set<String> eventNames, String consumerGroup, SubscriptionRequest.Position readFrom, @Nullable List<Cursor> initialCursors, @Nullable Authorization authorization) throws IOException {
        Preconditions.checkArgument(readFrom != SubscriptionRequest.Position.CURSORS || initialCursors != null && !initialCursors.isEmpty(), "Initial cursors are required for position: cursors");
        SubscriptionRequest subscription = new SubscriptionRequest(applicationName, eventNames, consumerGroup, readFrom, initialCursors, authorization);
        URI uri = this.baseUri.resolve("/subscriptions");
        Request request = this.requestFactory.createRequest(uri, "POST");
        request.getHeaders().setContentType(ContentType.APPLICATION_JSON);
        try (OutputStream os = request.getBody();){
            this.internalObjectMapper.writeValue(os, (Object)subscription);
        }
        try (Response response = request.execute();){
            Subscription subscription2;
            block19: {
                InputStream is = response.getBody();
                try {
                    Subscription subscriptionResponse = (Subscription)this.internalObjectMapper.readValue(is, Subscription.class);
                    LOG.info("Created subscription for event {} with id [{}]", subscription.getEventTypes(), (Object)subscriptionResponse.getId());
                    this.cursorManager.addSubscription(subscriptionResponse);
                    subscription2 = subscriptionResponse;
                    if (is == null) break block19;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return subscription2;
        }
    }

    public StreamBuilder.SubscriptionStreamBuilder stream(Subscription subscription) {
        Preconditions.checkState(this.cursorManager instanceof ManagedCursorManager, "Subscription api requires a ManagedCursorManager");
        return new StreamBuilders.SubscriptionStreamBuilderImpl(this.baseUri, this.requestFactory, this.cursorManager, this.objectMapper, subscription);
    }

    public StreamBuilder.LowLevelStreamBuilder stream(String eventName) {
        return new StreamBuilders.LowLevelStreamBuilderImpl(this.baseUri, this.requestFactory, this.cursorManager, this.objectMapper, eventName);
    }
}

