/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.failsafeactuator.endpoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.jodah.failsafe.CircuitBreaker;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.zalando.failsafeactuator.endpoint.domain.CircuitBreakerState;
import org.zalando.failsafeactuator.service.CircuitBreakerRegistry;

@ConfigurationProperties(prefix="endpoints.failsafe")
public class FailsafeEndpoint
extends AbstractEndpoint<List<CircuitBreakerState>> {
    private static final String ENDPOINT_ID = "failsafe";
    private final CircuitBreakerRegistry circuitBreakerRegistry;

    public FailsafeEndpoint(CircuitBreakerRegistry circuitBreakerRegistry) {
        super(ENDPOINT_ID);
        this.circuitBreakerRegistry = circuitBreakerRegistry;
    }

    public List<CircuitBreakerState> invoke() {
        Map<String, CircuitBreaker> breakerMap = this.circuitBreakerRegistry.getConcurrentBreakerMap();
        ArrayList<CircuitBreakerState> breakerStates = new ArrayList<CircuitBreakerState>();
        ArrayList<String> breakersToRemove = new ArrayList<String>();
        for (String identifier : breakerMap.keySet()) {
            CircuitBreaker breaker = breakerMap.get(identifier);
            if (breaker == null) {
                breakersToRemove.add(identifier);
                continue;
            }
            CircuitBreakerState state = new CircuitBreakerState(identifier, breaker.isClosed(), breaker.isOpen(), breaker.getState().equals((Object)CircuitBreaker.State.HALF_OPEN));
            breakerStates.add(state);
        }
        this.removeUnreferencedBreakers(breakersToRemove);
        return breakerStates;
    }

    private void removeUnreferencedBreakers(List<String> breakersToRemove) {
        for (String identifier : breakersToRemove) {
            this.circuitBreakerRegistry.getConcurrentBreakerMap().remove(identifier);
        }
    }
}

