/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.failsafeactuator.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import net.jodah.failsafe.CircuitBreaker;
import org.springframework.util.Assert;

public class CircuitBreakerRegistry {
    private final Map<String, CircuitBreaker> concurrentBreakerMap = new ConcurrentHashMap<String, CircuitBreaker>();

    void registerCircuitBreaker(CircuitBreaker breaker, String name) {
        Assert.hasText((String)name, (String)"Name for circuitbreaker needs to be set");
        Assert.notNull((Object)breaker, (String)"Circuitbreaker to add, can't be null");
        CircuitBreaker replaced = this.concurrentBreakerMap.put(name, breaker);
        Assert.isNull((Object)replaced, (String)("There was an Circuit-Breaker registered already with name : " + name));
    }

    public Map<String, CircuitBreaker> getConcurrentBreakerMap() {
        return this.concurrentBreakerMap;
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.concurrentBreakerMap.clear();
    }
}

