/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.failsafeactuator.config;

import java.lang.annotation.Annotation;
import net.jodah.failsafe.CircuitBreaker;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.zalando.failsafeactuator.config.FailsafeAutoConfiguration;
import org.zalando.failsafeactuator.service.CircuitBreakerRegistry;
import org.zalando.failsafeactuator.service.FailsafeBreaker;

@Configuration
@Conditional(value={FailsafeAutoConfiguration.FailsafeCondition.class})
public class FailsafeInjectionConfiguration {
    @Autowired
    private CircuitBreakerRegistry circuitBreakerRegistry;

    @Bean
    @Scope(value="prototype")
    public CircuitBreaker circuitBreaker(InjectionPoint ip) {
        FailsafeBreaker annotation = null;
        for (Annotation a : ip.getAnnotations()) {
            if (!(a instanceof FailsafeBreaker)) continue;
            annotation = (FailsafeBreaker)a;
            break;
        }
        return this.circuitBreakerRegistry.getOrCreate(annotation.value());
    }
}

