/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.failsafeactuator.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import net.jodah.failsafe.CircuitBreaker;
import org.springframework.util.Assert;

public class CircuitBreakerRegistry {
    private static final String ALREADY_REGISTERED_ERROR = "There was a Circuit-Breaker registered already with name : %s ";
    private final Map<String, CircuitBreaker> concurrentBreakerMap = new ConcurrentHashMap<String, CircuitBreaker>();

    void registerCircuitBreaker(CircuitBreaker breaker, String name) {
        Assert.hasText((String)name, (String)"Name for circuit breaker needs to be set");
        Assert.notNull((Object)breaker, (String)"Circuit breaker to add, can't be null");
        CircuitBreaker replaced = this.concurrentBreakerMap.put(name, breaker);
        Assert.isNull((Object)replaced, (String)String.format(ALREADY_REGISTERED_ERROR, name));
    }

    public Map<String, CircuitBreaker> getConcurrentBreakerMap() {
        return this.concurrentBreakerMap;
    }

    private CircuitBreaker createCircuitBreaker(String identifier) {
        CircuitBreaker breaker = new CircuitBreaker();
        this.registerCircuitBreaker(breaker, identifier);
        return breaker;
    }

    public CircuitBreaker getOrCreate(String identifier) {
        Assert.hasText((String)identifier, (String)"Identifier for circuit breaker needs to be set");
        CircuitBreaker circuitBreaker = this.concurrentBreakerMap.get(identifier);
        if (circuitBreaker != null) {
            return circuitBreaker;
        }
        return this.createCircuitBreaker(identifier);
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.concurrentBreakerMap.clear();
    }
}

