/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.failsafeactuator.config;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.zalando.failsafeactuator.endpoint.FailsafeEndpoint;
import org.zalando.failsafeactuator.service.CircuitBreakerRegistry;

@Configuration
@Conditional(value={FailsafeCondition.class})
public class FailsafeAutoConfiguration {
    private CircuitBreakerRegistry circuitBreakerRegistry;

    @Bean
    public CircuitBreakerRegistry circuitBreakerRegistry() {
        this.circuitBreakerRegistry = new CircuitBreakerRegistry();
        return this.circuitBreakerRegistry;
    }

    @Bean
    public FailsafeEndpoint createEndpoint(CircuitBreakerRegistry circuitBreakerRegistry, ApplicationContext applicationContext) {
        return new FailsafeEndpoint(circuitBreakerRegistry, applicationContext);
    }

    static class FailsafeCondition
    extends SpringBootCondition {
        FailsafeCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            boolean endpointsEnabled = this.isEnabled(context, "endpoints.", true);
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Failsafe", (Object[])new Object[0]);
            if (this.isEnabled(context, "endpoints.failsafe.", endpointsEnabled)) {
                return ConditionOutcome.match((ConditionMessage)message.because("enabled"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
        }

        private boolean isEnabled(ConditionContext context, String prefix, boolean defaultValue) {
            return (Boolean)context.getEnvironment().getProperty(prefix + ".enabled", Boolean.class, (Object)defaultValue);
        }
    }
}

