/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.failsafeactuator.endpoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jodah.failsafe.CircuitBreaker;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.zalando.failsafeactuator.endpoint.domain.CircuitBreakerState;
import org.zalando.failsafeactuator.service.CircuitBreakerRegistry;

@ConfigurationProperties(prefix="endpoints.failsafe")
public class FailsafeEndpoint
extends AbstractEndpoint<Map<String, CircuitBreakerState>> {
    private static final String ENDPOINT_ID = "failsafe";
    private final CircuitBreakerRegistry circuitBreakerRegistry;
    private final ApplicationContext context;

    public FailsafeEndpoint(CircuitBreakerRegistry circuitBreakerRegistry, ApplicationContext context) {
        super(ENDPOINT_ID);
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.context = context;
    }

    public Map<String, CircuitBreakerState> invoke() {
        Map<String, CircuitBreaker> breakerMap = this.circuitBreakerRegistry.getConcurrentBreakerMap();
        if (!breakerMap.isEmpty()) {
            return this.handleWithMap(breakerMap);
        }
        return this.handleWithApplicationContext();
    }

    private Map<String, CircuitBreakerState> handleWithApplicationContext() {
        HashMap<String, CircuitBreakerState> breakerStates = new HashMap<String, CircuitBreakerState>();
        Map beanNamesForType = this.context.getBeansOfType(CircuitBreaker.class, false, false);
        if (beanNamesForType == null) {
            return breakerStates;
        }
        for (String key : beanNamesForType.keySet()) {
            CircuitBreaker breaker = (CircuitBreaker)beanNamesForType.get(key);
            CircuitBreakerState state = new CircuitBreakerState(key, breaker.getState());
            breakerStates.put(key, state);
        }
        return breakerStates;
    }

    private Map<String, CircuitBreakerState> handleWithMap(Map<String, CircuitBreaker> breakerMap) {
        HashMap<String, CircuitBreakerState> breakerStates = new HashMap<String, CircuitBreakerState>();
        ArrayList<String> breakersToRemove = new ArrayList<String>();
        for (String identifier : breakerMap.keySet()) {
            CircuitBreaker breaker = breakerMap.get(identifier);
            if (breaker == null) {
                breakersToRemove.add(identifier);
                continue;
            }
            CircuitBreakerState state = new CircuitBreakerState(identifier, breaker.getState());
            breakerStates.put(identifier, state);
        }
        this.removeUnreferencedBreakers(breakersToRemove);
        return breakerStates;
    }

    private void removeUnreferencedBreakers(List<String> breakersToRemove) {
        for (String identifier : breakersToRemove) {
            this.circuitBreakerRegistry.getConcurrentBreakerMap().remove(identifier);
        }
    }
}

