/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.actuate.failsafe;

import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.jodah.failsafe.CircuitBreaker;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.zalando.actuate.failsafe.CircuitBreakerView;
import org.zalando.actuate.failsafe.Container;

@Endpoint(id="circuit-breakers")
public class CircuitBreakersEndpoint {
    private final Map<String, CircuitBreaker> breakers;

    public CircuitBreakersEndpoint(Map<String, CircuitBreaker> breakers) {
        this.breakers = breakers;
    }

    @ReadOperation
    public Container circuitBreakers() {
        Map<String, CircuitBreakerView> circuitBreakers = this.breakers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.toView((CircuitBreaker)entry.getValue())));
        return new Container(circuitBreakers);
    }

    @ReadOperation
    @Nullable
    public CircuitBreakerView circuitBreaker(@Selector String name) {
        CircuitBreaker breaker = this.breakers.get(name);
        if (breaker == null) {
            return null;
        }
        return this.toView(breaker);
    }

    @WriteOperation
    @Nullable
    public CircuitBreakerView transitionTo(@Selector String name, CircuitBreaker.State state) {
        CircuitBreaker breaker = this.breakers.get(name);
        if (breaker == null) {
            return null;
        }
        this.transitioner(state).accept(breaker);
        return this.toView(breaker);
    }

    private CircuitBreakerView toView(CircuitBreaker breaker) {
        return new CircuitBreakerView(breaker.getState());
    }

    private Consumer<CircuitBreaker> transitioner(CircuitBreaker.State state) {
        switch (state) {
            case CLOSED: {
                return CircuitBreaker::close;
            }
            case OPEN: {
                return CircuitBreaker::open;
            }
            case HALF_OPEN: {
                return CircuitBreaker::halfOpen;
            }
        }
        throw new UnsupportedOperationException("Unknown state: " + state);
    }
}

