/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.flatjson;

import java.util.List;
import java.util.Map;
import org.zalando.flatjson.Json;
import org.zalando.flatjson.JsonList;
import org.zalando.flatjson.JsonMap;
import org.zalando.flatjson.StringCodec;

class Literal
extends Json {
    Literal() {
    }

    static class Object
    extends Literal {
        private final Map<String, Json> map = new JsonMap<String, Json>();

        Object() {
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public Map<String, Json> asObject() {
            return this.map;
        }

        public String toString() {
            return this.map.toString();
        }
    }

    static class Array
    extends Literal {
        private final List<Json> list;

        Array(List<Json> values) {
            this.list = new JsonList<Json>(values);
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public List<Json> asArray() {
            return this.list;
        }

        public String toString() {
            return this.list.toString();
        }
    }

    static class Strng
    extends Literal {
        private final String string;

        Strng(String string) {
            this.string = string;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public String asString() {
            return this.string;
        }

        public String toString() {
            return String.format("\"%s\"", StringCodec.escape(this.string));
        }
    }

    static class Number
    extends Literal {
        private final String value;

        Number(long value) {
            this.value = Long.toString(value);
        }

        Number(double value) {
            this.value = Double.toString(value);
        }

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public long asLong() {
            return Long.valueOf(this.value);
        }

        @Override
        public double asDouble() {
            return Double.valueOf(this.value);
        }

        public String toString() {
            return this.value;
        }
    }

    static class Bool
    extends Literal {
        private final boolean value;

        Bool(boolean value) {
            this.value = value;
        }

        @Override
        public boolean isBoolean() {
            return true;
        }

        @Override
        public boolean asBoolean() {
            return this.value;
        }

        public String toString() {
            return Boolean.toString(this.value);
        }
    }

    static class Null
    extends Literal {
        Null() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        public String toString() {
            return "null";
        }
    }
}

