/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.flatjson;

import java.util.List;
import java.util.Map;
import org.zalando.flatjson.Json;
import org.zalando.flatjson.JsonList;
import org.zalando.flatjson.JsonMap;
import org.zalando.flatjson.Overlay;

class Parsed
extends Json {
    Parsed() {
    }

    static class Object
    extends Value {
        private Map<String, Json> map;

        Object(Overlay overlay, int element) {
            super(overlay, element);
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public Map<String, Json> asObject() {
            if (this.map == null) {
                this.map = this.createMap();
            }
            return this.map;
        }

        @Override
        public String toString() {
            return this.map == null ? super.toString() : this.map.toString();
        }

        private Map<String, Json> createMap() {
            JsonMap<String, Json> result = new JsonMap<String, Json>();
            for (int e = this.element + 1; e <= this.element + this.overlay.getNested(this.element); e += this.overlay.getNested(e + 1) + 2) {
                String key = this.overlay.getUnescapedString(e);
                result.put(key, Object.create(this.overlay, e + 1));
            }
            return result;
        }
    }

    static class Array
    extends Value {
        private List<Json> array;

        Array(Overlay overlay, int element) {
            super(overlay, element);
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public List<Json> asArray() {
            if (this.array == null) {
                this.array = this.createArray();
            }
            return this.array;
        }

        @Override
        public String toString() {
            return this.array == null ? super.toString() : this.array.toString();
        }

        private List<Json> createArray() {
            JsonList<Json> result = new JsonList<Json>();
            for (int e = this.element + 1; e <= this.element + this.overlay.getNested(this.element); e += this.overlay.getNested(e) + 1) {
                result.add(Array.create(this.overlay, e));
            }
            return result;
        }
    }

    static class Strng
    extends Value {
        private String string;

        Strng(Overlay overlay, int element) {
            super(overlay, element);
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public String asString() {
            if (this.string == null) {
                this.string = this.overlay.getUnescapedString(this.element);
            }
            return this.string;
        }
    }

    static class Number
    extends Value {
        Number(Overlay overlay, int element) {
            super(overlay, element);
        }

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public long asLong() {
            return Long.valueOf(this.overlay.getJson(this.element));
        }

        @Override
        public double asDouble() {
            return Double.valueOf(this.overlay.getJson(this.element));
        }
    }

    static class Bool
    extends Value {
        Bool(Overlay overlay, int element) {
            super(overlay, element);
        }

        @Override
        public boolean isBoolean() {
            return true;
        }

        @Override
        public boolean asBoolean() {
            return Boolean.valueOf(this.overlay.getJson(this.element));
        }
    }

    static class Value
    extends Parsed {
        protected final Overlay overlay;
        protected final int element;

        Value(Overlay overlay, int element) {
            this.overlay = overlay;
            this.element = element;
        }

        @Override
        public boolean isNull() {
            return this.overlay.getType(this.element) == Json.Type.NULL;
        }

        public String toString() {
            return this.overlay.getJson(this.element);
        }
    }
}

