/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.flatjson;

import java.util.Stack;
import org.zalando.flatjson.StringCodec;
import org.zalando.flatjson.Visitor;

class PrettyPrinter
implements Visitor {
    private final StringBuilder builder = new StringBuilder();
    private final Stack<Context> context = new Stack();
    private final String indent;

    PrettyPrinter(String indent) {
        this.context.push(new Context(Type.TOP));
        this.indent = indent;
    }

    @Override
    public void visitNull() {
        this.append("null");
    }

    @Override
    public void visitBoolean(boolean value) {
        this.append(Boolean.toString(value));
    }

    @Override
    public void visitNumber(String value) {
        this.append(value);
    }

    @Override
    public void visitString(String value) {
        this.append(String.format("\"%s\"", StringCodec.escape(value)));
    }

    @Override
    public void beginArray() {
        this.append("[");
        this.context.push(new Context(Type.ARRAY));
    }

    @Override
    public void endArray() {
        if (this.current().type != Type.ARRAY) {
            throw new IllegalStateException("not inside array");
        }
        if (this.current().count > 0 && this.indent != null) {
            this.builder.append("\n");
            for (int i = 2; i < this.context.size(); ++i) {
                this.builder.append(this.indent);
            }
        }
        this.builder.append("]");
        this.context.pop();
    }

    @Override
    public void beginObject() {
        this.append("{");
        this.context.push(new Context(Type.OBJECT));
    }

    @Override
    public void endObject() {
        if (this.current().type != Type.OBJECT) {
            throw new IllegalStateException("not inside object");
        }
        if (this.current().count % 2 == 1) {
            throw new IllegalStateException("unbalanced object");
        }
        if (this.current().count > 0 && this.indent != null) {
            this.builder.append("\n");
            for (int i = 2; i < this.context.size(); ++i) {
                this.builder.append(this.indent);
            }
        }
        this.builder.append("}");
        this.context.pop();
    }

    public String toString() {
        if (this.context.size() > 1) {
            throw new IllegalStateException("unbalanced json");
        }
        return this.builder.toString();
    }

    private void append(String value) {
        if (this.current().type == Type.TOP) {
            if (this.current().count > 0) {
                throw new IllegalStateException("multiple toplevel values");
            }
        } else if (this.current().type == Type.ARRAY) {
            if (this.current().count > 0) {
                this.builder.append(",");
            }
            if (this.indent != null) {
                this.builder.append("\n");
                for (int i = 1; i < this.context.size(); ++i) {
                    this.builder.append(this.indent);
                }
            }
        } else if (this.current().type == Type.OBJECT) {
            if (this.current().count % 2 == 0) {
                if (this.current().count > 0) {
                    this.builder.append(",");
                }
                if (this.indent != null) {
                    this.builder.append("\n");
                    for (int i = 1; i < this.context.size(); ++i) {
                        this.builder.append(this.indent);
                    }
                }
            } else {
                this.builder.append(":");
                if (this.indent != null) {
                    this.builder.append(" ");
                }
            }
        }
        this.builder.append(value);
        this.current().count++;
    }

    private Context current() {
        return this.context.peek();
    }

    private class Context {
        private Type type;
        private int count = 0;

        Context(Type type) {
            this.type = type;
        }
    }

    private static enum Type {
        TOP,
        ARRAY,
        OBJECT;

    }
}

