/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.flatjson;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.zalando.flatjson.Literal;
import org.zalando.flatjson.Overlay;
import org.zalando.flatjson.ParseException;
import org.zalando.flatjson.Parsed;
import org.zalando.flatjson.PrettyPrinter;
import org.zalando.flatjson.Visitor;

public class Json {
    public static final String DEFAULT_INDENT = "  ";
    public static final Json NULL = new Literal.Null();
    public static final Json TRUE = new Literal.Bool(true);
    public static final Json FALSE = new Literal.Bool(false);

    protected static Json create(Overlay overlay, int element) {
        Type type = overlay.getType(element);
        switch (type) {
            case NULL: {
                return new Literal.Null();
            }
            case TRUE: 
            case FALSE: {
                return new Literal.Bool(Boolean.valueOf(overlay.getJson(element)));
            }
            case NUMBER: {
                return new Literal.Number(overlay.getJson(element));
            }
            case STRING_ESCAPED: 
            case STRING: {
                return new Parsed.Strng(overlay, element);
            }
            case ARRAY: {
                return new Parsed.Array(overlay, element);
            }
            case OBJECT: {
                return new Parsed.Object(overlay, element);
            }
        }
        throw new ParseException("unknown type: " + (Object)((Object)type));
    }

    public static Json parse(String raw) {
        return Json.create(new Overlay(raw), 0);
    }

    public static Json value(boolean value) {
        return new Literal.Bool(value);
    }

    public static Json value(int value) {
        return new Literal.Number(Integer.toString(value));
    }

    public static Json value(long value) {
        return new Literal.Number(Long.toString(value));
    }

    public static Json value(float value) {
        return new Literal.Number(Float.toString(value));
    }

    public static Json value(double value) {
        return new Literal.Number(Double.toString(value));
    }

    public static Json value(BigInteger value) {
        return value == null ? new Literal.Null() : new Literal.Number(value.toString());
    }

    public static Json value(BigDecimal value) {
        return value == null ? new Literal.Null() : new Literal.Number(value.toString());
    }

    public static Json value(String value) {
        return value == null ? new Literal.Null() : new Literal.Strng(value);
    }

    public static Json array(Json ... values) {
        return new Literal.Array(Arrays.asList(values));
    }

    public static Json object() {
        return new Literal.Object();
    }

    public boolean isNull() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean asBoolean() {
        throw new IllegalStateException("not a boolean");
    }

    public int asInt() {
        throw new IllegalStateException("not a number");
    }

    public long asLong() {
        throw new IllegalStateException("not a number");
    }

    public float asFloat() {
        throw new IllegalStateException("not a number");
    }

    public double asDouble() {
        throw new IllegalStateException("not a number");
    }

    public BigInteger asBigInteger() {
        throw new IllegalStateException("not a number");
    }

    public BigDecimal asBigDecimal() {
        throw new IllegalStateException("not a number");
    }

    public String asString() {
        throw new IllegalStateException("not a string");
    }

    public List<Json> asArray() {
        throw new IllegalStateException("not an array");
    }

    public Map<String, Json> asObject() {
        throw new IllegalStateException("not an object");
    }

    public void accept(Visitor visitor) {
        throw new IllegalStateException("not implemented");
    }

    public String prettyPrint() {
        return this.prettyPrint(DEFAULT_INDENT);
    }

    public String prettyPrint(String indent) {
        PrettyPrinter printer = new PrettyPrinter(indent);
        this.accept(printer);
        return printer.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Json)) {
            return false;
        }
        Json json = (Json)other;
        return this.prettyPrint().equals(json.prettyPrint());
    }

    public int hashCode() {
        return this.prettyPrint().hashCode();
    }

    static enum Type {
        NULL,
        TRUE,
        FALSE,
        NUMBER,
        STRING,
        STRING_ESCAPED,
        ARRAY,
        OBJECT;

    }
}

