/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.flatjson;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.zalando.flatjson.Json;
import org.zalando.flatjson.JsonList;
import org.zalando.flatjson.JsonMap;
import org.zalando.flatjson.StringCodec;
import org.zalando.flatjson.Visitor;

class Literal
extends Json {
    Literal() {
    }

    static class Object
    extends Literal {
        private final Map<String, Json> map = new JsonMap<String, Json>();

        Object() {
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public Map<String, Json> asObject() {
            return this.map;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.beginObject();
            for (Map.Entry<String, Json> entry : this.map.entrySet()) {
                visitor.visitString(entry.getKey());
                entry.getValue().accept(visitor);
            }
            visitor.endObject();
        }

        public String toString() {
            return this.map.toString();
        }
    }

    static class Array
    extends Literal {
        private final List<Json> list;

        Array(List<Json> values) {
            this.list = new JsonList<Json>(values);
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public List<Json> asArray() {
            return this.list;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.beginArray();
            for (Json value : this.list) {
                value.accept(visitor);
            }
            visitor.endArray();
        }

        public String toString() {
            return this.list.toString();
        }
    }

    static class Strng
    extends Literal {
        private final String string;

        Strng(String string) {
            this.string = string;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public String asString() {
            return this.string;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitString(this.string);
        }

        public String toString() {
            return String.format("\"%s\"", StringCodec.escape(this.string));
        }
    }

    static class Number
    extends Literal {
        private final String value;

        Number(String value) {
            this.value = value;
        }

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public int asInt() {
            return Integer.valueOf(this.value);
        }

        @Override
        public long asLong() {
            return Long.valueOf(this.value);
        }

        @Override
        public float asFloat() {
            return Float.valueOf(this.value).floatValue();
        }

        @Override
        public double asDouble() {
            return Double.valueOf(this.value);
        }

        @Override
        public BigInteger asBigInteger() {
            return new BigInteger(this.value);
        }

        @Override
        public BigDecimal asBigDecimal() {
            return new BigDecimal(this.value);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNumber(this.value);
        }

        public String toString() {
            return this.value;
        }
    }

    static class Bool
    extends Literal {
        private final boolean value;

        Bool(boolean value) {
            this.value = value;
        }

        @Override
        public boolean isBoolean() {
            return true;
        }

        @Override
        public boolean asBoolean() {
            return this.value;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitBoolean(this.value);
        }

        public String toString() {
            return Boolean.toString(this.value);
        }
    }

    static class Null
    extends Literal {
        Null() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNull();
        }

        public String toString() {
            return "null";
        }
    }
}

